#include "PICA/pica.h"
#include <stdlib.h>
#include <malloc.h>

#include <windows.h>
#include <stdio.h>

#include <Iphlpapi.h>


//globals

PICAmutex mymut;
PICAsemaphore mysem;

DEVLIST devs;

//function called for thread creation

void thrfunc(void * data) {
  char * dados;

  dados = (char *) data;

  printf("Dados da thread: %s\nThread:Trying to acquire mutex\n",dados);

	if (!PICAmutexAction(MUTEX_ACQUIRE, &mymut)) printf("Error acquiring mutex in thread\n");
	else printf("Mutex acquired in thread\n");
  
	printf("Thread: Trying to acquire semaphore\n");
	if (!PICAsemaphoreAction(SEMAPHORE_ACQUIRE, &mysem,4)) printf("Error acquiring sem. in thread\n");
	else printf("Sem. acquired in thread\n");

	printf("Thread: I'm working in critical session!!! :P \n");
    Sleep(2000);

	printf("Thread: I ended to work in critical session!!! :P \n");
	if (!PICAmutexAction(MUTEX_RELEASE, &mymut)) printf("Error releasing mutex\n");
	else printf("Mutex released in thread\n");

	if (!PICAsemaphoreAction(SEMAPHORE_RELEASE, &mysem,1)) printf("Error releasing sem\n");
	else printf("Sem. released in thread\n");

	Sleep(2000);

	while(1) {
		printf("in the thread!\n");
		Sleep(1000);
	}

}

//function activated on timer UP

void timerfunc(void * data) {
  

  printf("Timer activated. Input data to function is: %s\n",(char *) data);

}

//function showing how to use the PICA timer

void test_timer(void) {

  char buf[100];
  char* msg;
  char  buf5[] = "555555";
  char  buf6[] = "666666";
  char  buf7[] = "777777";
  char  buf8[] = "888888";
  UINT64 dif;
  int code, err;
	

  	printf("\n------------------ Timer test -----------------\n");

	msg= (char *)GlobalAlloc(GMEM_FIXED, sizeof(char));

	dif = PICAgetCurrTime();

	dif += 3000;

	printf("Setting timer FIRST time\n");

	if (!PICAtimer(T_STARTUP, NULL, NULL, NULL)) printf("Error statring timer\n");
	else printf("Success starting timer\n");


	if (!PICAtimer(T_SET, &dif, &timerfunc, buf6)) {
		PICAgetLastError(buf,&code);	
		printf("Error setting timer: %s\n",buf);
	}
	else printf("Success setting timer at 3000 sec after starting\n");


	dif -=1500;

	if (!PICAtimer(T_SET, &dif, &timerfunc, buf5)) printf("Error setting timer\n");
	else printf("Success setting timer at 1500 sec after starting\n");


	//if (!PICAtimer(T_STOP, &dif, &timerfunc, buf5)) printf("Error stopping timer\n");
	//else printf("Success stopping timer\n");

	if (!PICAtimer(T_KILL, NULL, NULL, NULL)) printf("Error killing timer\n");
	else printf("Success killing timer\n");



	//again

	dif = PICAgetCurrTime();

	dif += 3000;


	if (!PICAtimer(T_STARTUP, NULL, NULL, NULL)) printf("Error starting timer\n");
	else printf("Success starting timer\n");


	if (!PICAtimer(T_SET, &dif, &timerfunc, buf6)) printf("Error setting timer\n");
	else printf("Success setting timer at 3000 sec after starting with buf6\n");


	dif -=1500;

	if (!PICAtimer(T_SET, &dif, &timerfunc, buf5)) printf("Error setting timer\n");
	else printf("Success setting timer at 1500 sec after starting with buf5\n");

	dif +=500;

	if (!PICAtimer(T_SET, &dif, &timerfunc, buf7)) printf("Error setting timer\n");
	else printf("Success setting timer at 2000 sec after starting with buf7\n");

	dif -=250;

	if (!PICAtimer(T_SET, &dif, &timerfunc,buf8 )) printf("Error setting timer\n");
	else printf("Success setting timer at 1750 sec after starting with buf8\n");
	if (!PICAtimer(T_SET, &dif, &timerfunc, buf5)) printf("Error setting timer\n");
	else printf("Success setting timer at 1750 sec after starting with buf5\n");

	//if (!PICAtimer(T_STOP, &dif, &timerfunc, buf8)) printf("Error stopping timer\n");
	//else printf("Success stopping timer\n");

		Sleep(5000);

	if (!PICAtimer(T_STOP, &dif, &timerfunc, buf7))
	{
		PICAgetLastError(buf,&code);	
		printf("Error setting timer: %s\n",buf);
		//printf("Error stopping timer:");
	}
	else printf("Success stopping timer of buf7\n");



	if (!PICAtimer(T_KILL, NULL, NULL, NULL)) printf("Error killing timer\n");
	else printf("Success killing timer\n");

}



//function showing how to use the PICA buffering capabilities
/*
void test_buffering2(void){

char * buf1;
  char * buf2;
  char * buf3;
  char * buf4;

  PICAbuffer * pbuf;
  PICAbuffer ** aux;
  PICApacket * packets;
  int i, size, avail_packets, j;

  printf("\n------------------ Buffer test -----------------\n");
	
  if (!PICAinitBuffer(&pbuf, 3)) printf("Error starting buffer\n");
  else printf("Buffer initiated\n");
 
	printf("creating data to put in buffer...");
	buf1=(char*)malloc(20);
	buf2=(char*)malloc(20*sizeof(char));
	buf3=(char*)malloc(20*sizeof(char));
	buf4=(char*)malloc(20*sizeof(char));

	for(i=0;i<19;i++)
	{
		buf1[i]='a';
		buf2[i]='b';
		buf3[i]='c';
		buf4[i]='d';
	}

		buf1[19]='\n';
		buf2[19]='\n';
		buf3[19]='\n';
		buf4[19]='\n';

	printf("sto per liberare il buf4\n");
	free(buf4);
	printf("liberato!!!!!!!!!!!\n");
  
	size = strlen(buf1);
  printf("size: %d\n", size);
	
	printf("buf1:%s\n", buf1);

	printf("buf1 char\n");
	for(i=0;i<20;i++)
	{
		printf("%c", buf1[i]);
	}



}


*/
void test_buffering(void) {

  /*
  NON POSSO DICHIARARLO COSI' PERCHE`MI SI BLOCCA LA FREE
  char  buf1[] = "Dados do buffer1";
  char  buf2[] = "Dados do buffer2";
  char  buf3[] = "Dados do buffer3";
  char  buf4[] = "Dados do buffer4";
  */

 char * buf1;
  char * buf2;
  char * buf3;
  char * buf4;


 /*PSECURITY_DESCRIPTOR  buf1;
  PSECURITY_DESCRIPTOR  buf2;
PSECURITY_DESCRIPTOR  buf3;
PSECURITY_DESCRIPTOR buf4;
*/
  PICAbuffer * pbuf;
  PICAbuffer ** aux;
  PICApacket * packets;
  int i, size, avail_packets, j;

  int  num_queues;
  PICApacket * curr_pos, * next_pos;
  HANDLE * mut_copy;
  LPVOID p1, p2, p3, p4;
  PICApacket * mem_punt[4];



  
  printf("\n------------------ Buffer test -----------------\n");
	
  if (!PICAinitBuffer(&pbuf, 3)) printf("Error starting buffer\n");
  else printf("Buffer initiated\n");
 
	printf("creating data to put in buffer...");
	//buf1=(char*)malloc(20*sizeof(char));
	/*buf1=(char*)malloc(20);
	buf2=(char*)malloc(20*sizeof(char));
	buf3=(char*)malloc(20*sizeof(char));
	buf4=(char*)malloc(20*sizeof(char));
	*/
	buf1=GlobalAlloc(GMEM_FIXED, 20*sizeof(char));
	buf2=GlobalAlloc(GMEM_FIXED, 20*sizeof(char));
	buf3=GlobalAlloc(GMEM_FIXED, 20*sizeof(char));
	buf4=GlobalAlloc(GMEM_FIXED, 20*sizeof(char));
	/*
heap=HeapCreate(HEAP_GENERATE_EXCEPTIONS, 80*sizeof(char), 200*sizeof(char));

	buf1=heapAlloc(heap, HEAP_ZERO_MEMORY, 20*sizeof(char));
	buf2=heapAlloc(heap, HEAP_ZERO_MEMORY, 20*sizeof(char));
	buf3=heapAlloc(heap, HEAP_ZERO_MEMORY, 20*sizeof(char));
	buf4=heapAlloc(heap, HEAP_ZERO_MEMORY, 20*sizeof(char));
*/


	for(i=0;i<20;i++)
	{
		buf1[i]='a';
		buf2[i]='b';
		buf3[i]='c';
		buf4[i]='d';
	}
	//METTERE SEMPRE QUESTO CARATTERE ALLA FINE LINEA!!!!!!!!!!!!!
		buf1[19]='\0';
		buf2[19]='\0';
		buf3[19]='\0';
		buf4[19]='\0'; 
	/*printf("sto per liberare il buf4\n");
	GlobalFree(buf4);
	printf("liberato!!!!!!!!!!!\n");
  */
	size = strlen(buf1);
  printf("size: %d\n", size);
	
	printf("buf1:%s\n", buf1);



  
  if (!PICAaddToBuffer(pbuf,2, buf1, size)) printf("Error adding to buffer\n");
  else printf("Added %s to buffer in queue num 2\n", buf1);

 if (!PICAaddToBuffer(pbuf,2, buf2, size)) printf("Error adding to buffer\n");
  else printf("Added %s to buffer in queue num 2\n", buf2);

 if (!PICAaddToBuffer(pbuf,2, buf3, size)) printf("Error adding to buffer\n");
  else printf("Added %s to buffer in queue num 2\n", buf3);

if (!PICAaddToBuffer(pbuf,2, buf4, size)) printf("Error adding to buffer\n");
    else printf("Added %s to buffer in queue num 2\n", buf4);



 for (i=0;i<3;i++) {
  
   printf("\nTring to get 3 packet from queue %d\n",i);

   if (!PICAgetFromBuffer(pbuf, i, 3, &packets,&avail_packets)) printf("Error getting from buffer\n");
   else printf("Got data from buffer: avail_packets: %d\n",avail_packets);

   if(avail_packets != 0)
   {
	   if (packets == NULL) printf ("packets is null\n");

	   while (packets != NULL) {
		   printf("packet size: %d  ", packets->packet_size);
		 printf("  Data: %s\n",(char *) packets->data);
		 packets = packets->next;
	   }
	  
	   printf("trying to get from queue %d an other time\n", i);
	    i--;	
   }   
 }

 if (!PICAkillBuffer(pbuf)) printf("Error killing buffer\n");
  else printf("Buffer killed\n");


}


//function showing how to use the PICA select call

void test_select(void) {

	HANDLE myevent, myevent2;
	PICAsocket mysock;
	PICAdescList * dl, * jump, * run;
	PICAselResult res;
	PICApipe in, out;
	char buf[100] = "Data sent to pipe";
	int code, written;

	printf("\n------------------ Select test -----------------\n");
	
	myevent = CreateEvent(NULL,FALSE,FALSE,NULL);
	myevent2 = CreateEvent(NULL,FALSE,FALSE,NULL);
	SetEvent(myevent2);

	if (!PICAmakePipe(&in, &out)) printf("Error creating pipe\n");




if (!PICAcreateSocket(&mysock,PF_INET, SOCK_DGRAM, 0)) printf("Error creating socket\n");
  else printf("socket created\n");
  
  //if (!PICAsendToPipe(out, buf, strlen(buf), &written)) printf("Error writing to pipe\n");

	printf("\nStarting select\n");

	dl = NULL;
		
	if (!PICAaddDesc(&dl, PICA_PIPE_TYPE,&in)) printf("Error adding descriptor\n");
	if (!PICAaddDesc(&dl, PICA_SOCKET_TYPE, &mysock)) printf("Error adding descriptor\n");
	if (!PICAaddDesc(&dl, PICA_SOCKET_TYPE, &mysock)) printf("Error adding descriptor\n");
	if (!PICAaddDesc(&dl, PICA_OTHER_TYPE, &myevent)) printf("Error adding descriptor\n");
	if (!PICAaddDesc(&dl, PICA_OTHER_TYPE, &myevent2)) printf("Error adding descriptor\n");


//	printf("main: dl is %x\n",dl);

	if (!PICAselect(PICA_WAIT_FOREVER, dl,  &res)) {
		PICAgetLastError(buf,&code);
		printf("Error in PICAselect: %s\n", buf);
	}
	else {
		printf("Success in select\n");
		if (res.type == PICA_TIMEOUT_TYPE) printf("Selection result is timeout\n");
		else if (res.type == PICA_PIPE_TYPE)
		{
			printf("Selection result is pipe type\n");
			sprintf(buf,"");
			PICAgetFromPipe(in, buf, 100, &written);
			buf[written] = '\0';
			printf("Pipe activated. Data from pipe: %s\n",buf);
		}
		else printf("Results: type = %d desc= %x. event desc= %x\n",res.type,res.desc, &myevent2);
	}   	


	if (!PICAsendToPipe(out, buf, strlen(buf)+1, &written)) printf("Error writing to pipe\n");

	if (!PICAselect(5000, dl,  &res)) {
		PICAgetLastError(buf,&code);
		printf("Error in PICAselect: %s\n", buf);
	}
	else {
		printf("Success in select\n");
		if (res.type == PICA_TIMEOUT_TYPE) printf("Selection result is timeout\n");
		else if (res.type == PICA_PIPE_TYPE)
		{
			printf("Selection result is pipe type\n");		
			sprintf(buf,"");
			PICAgetFromPipe(in, buf, 100, &written);			
			printf("Pipe activated. Data: %s\n",buf);
		}
		else printf("Results: type = %d desc= %x. event desc= %x\n",res.type,res.desc, &myevent2);
	}

	CloseHandle(myevent);
	CloseHandle(myevent2);
	PICAclosePipe(in);
	PICAclosePipe(out);
	PICAcloseSocket(mysock);
}

//function showing how to use the PICA pipes

void test_pipe(void) {

	PICApipe inpipe, outpipe;	
	int len, ret;
	char pdata[] = "estes sao os meus dados";
	//char buf[100];
	char * buf;
	

	printf("\n------------------ Pipe test -----------------\n");

	len = strlen(pdata);

	buf = (char*)malloc(100*sizeof(char));
 
    if (!PICAmakePipe(&inpipe, &outpipe)) printf("Error making pipe\n");
    else printf("Success opening pipes\n");


    if (!PICAsendToPipe(outpipe, pdata, len+100, &ret)) {
		PICAgetLastError(buf,&ret);
		printf("Error sending: %s\n", buf);        
	}
	else printf("Sent %d bytes and writte %d really\n", len, ret);

	if (WaitForSingleObject(inpipe.event,0) == WAIT_OBJECT_0) printf("Pipe event activated\n");
	else printf("Pipe event not activated\n");

    if (!PICAgetFromPipe(inpipe, buf, 100, &ret)) printf("Error receiving\n");
    else {
            buf[ret] = '\0';
            printf("received %d bytes: %s\n",ret,buf);
    }



    if (!PICAclosePipe(inpipe)) printf("Error closing pipe\n");
    else printf("Closed pipe\n");
    if (!PICAclosePipe(outpipe)) printf("Error closing pipe\n");
    else printf("Closed pipe\n");
	

}

//function showing how to use the PICA routing table manipulation calls

void test_rtable(void) {

	char buf[100];
	int code, i;
	RTInfo rt;
	RTLines * line;
 struct in_addr dest,mask,gw; 
  char s_dest[16], s_mask[16], s_gw[16];
	
	printf("\n------------------ Routing table test -----------------\n");

	for (i=0;i<devs.num_devices;i++)
	{

		printf("used device: %s\n",devs.dev_names[i]);

		if (PICAaddRoute(inet_addr("192.168.0.6"),inet_addr("255.255.255.255"),inet_addr("192.168.0.1"),1,devs.dev_names[i])) printf("Sucess adding route 192.168.0.6 maask:255.255.255.255 gw:192.168.0.1\n");
		else 
		{
			PICAgetLastError(buf,&code);
			printf("Error num %d adding route: %s\n",code, buf);
		}
		printf("second time:\n");
	
		if (PICAaddRoute(inet_addr("192.168.0.33"),inet_addr("255.255.255.255"),inet_addr("192.168.0.99"),1,devs.dev_names[i])) printf("Sucess adding route 192.168.0.33 maask:255.255.255.255 gw:192.168.0.99\n");
		else
		{
			PICAgetLastError(buf,&code);
			printf("Error num %d adding route: %s\n",code, buf);
		}

/*
		if (!PICAgetRoutingTable(& rt)) 
		{
			PICAgetLastError(buf,&code);
			printf("Error reading RT: %s\n",buf);
		}
		else 
		{
			printf("Success reading RT\n");

			printf("Linhas: %d\n", rt.entry_count);
			printf("\tdest\t\tmask\t\tgw\tmetric\tif\n"); 
			line = rt.lines;
			while (line != NULL)
			{
				dest.s_addr = line->dest;
				strcpy(s_dest,inet_ntoa(dest));
				mask.s_addr = line->mask;
				strcpy(s_mask,inet_ntoa(mask));
				gw.s_addr = line->gw;
				strcpy(s_gw,inet_ntoa(gw));
				printf("%14s\t%14s\t%14s\t%3d\t%4s\n",s_dest,s_mask,s_gw,line->metric,line->device);
				line = line->next;
			}
		}


		if (PICAdelRoute(inet_addr("192.168.0.33"),inet_addr("255.255.255.255"),inet_addr("192.168.0.99"),devs.dev_names[i])) printf("Success removing route\n");
		else printf("Error removing route\n");

		 printf("second time:\n");
if(PICAdelRoute(inet_addr("192.168.0.33"),inet_addr("255.255.255.255"),inet_addr("192.168.0.99"),devs.dev_names[i])) printf("Success removing route\n");
  {
	PICAgetLastError(buf,&code);
	  printf("Error deleting RT: %s\n",buf);
	  if(code==ERROR_NOT_FOUND)
		  printf("entri not found\n");
	  else
		  printf("altro errore\n");
	}*/
  }


}

//function showing how to use the PICA forwarding calls

void test_forwarding(void) {
  	
	int true_false;

  printf("\n------------------ Forwarding test -----------------\n");
	
  if (!PICAisForwarding(&true_false)) printf("Error getting forwarding state\n");
  else printf("Forwarding is %s\n",true_false>0?"ON":"OFF");
  
  if (true_false > 0)
  {
  printf("set forwarding OFF.\n");
  if (!PICAsetForwarding(FWD_OFF)) printf("Error stopping forwarding\n");
  else {
	if (!PICAisForwarding(&true_false)) printf("Error getting forwarding state\n");
  else printf("Forwarding is %s\n",true_false>0?"ON":"OFF");
  
  }
  }
  else
  {
  printf("set forwarding ON.\n");
  if (!PICAsetForwarding(FWD_ON)) printf("Error starting forwarding\n");
  else {
	if (!PICAisForwarding(&true_false)) printf("Error getting forwarding state\n");
	else printf("Forwarding is %s\n",true_false>0?"ON":"OFF");
  
  }
  }
  
}


//function showing how to use the PICA forwarding calls

void test_TTL(void) {

	int ttl;

	  printf("\n------------------ TTL test -----------------\n");

	  ttl = 77;

	if (!PICAdefaultTTL(TTL_SET, &ttl)) printf("Error setting TTL\n");
	else printf("TTL set to %d\n",ttl);

	if (!PICAdefaultTTL(TTL_GET, &ttl)) printf("Error getting TTL\n");
	else printf("System TTL is %d\n",ttl);

	ttl = 64;

	if (!PICAdefaultTTL(TTL_SET, &ttl)) printf("Error setting TTL\n");
	else printf("TTL set to %d\n",ttl);

	if (!PICAdefaultTTL(TTL_GET, &ttl)) printf("Error getting TTL\n");
	else printf("System TTL is %d\n",ttl);

}


//function showing how to use the PICA device calls

void test_devices(void) {

  DevAttrs * attrs;
  struct in_addr ip;
  int i;

  attrs = (DevAttrs * )malloc(sizeof(DevAttrs));

   printf("\n------------------ Device test -----------------\n");
  
   if (PICAgetAvailableDevices(&devs) == 0) printf("Error getting available devices\n");
  else 
  {
    printf("devices obtained: %d\n",devs.num_devices);
    for (i=0;i<devs.num_devices;i++)
	{
		printf("princ: dev %d is %s\n",i, devs.dev_names[i]);  
		if (PICAgetDeviceAttrs(devs.dev_names[i], attrs) == 0) printf("Error device attributes\n");
		else
		{
			printf("Attributes:\n");
			ip.s_addr = attrs->ip_addr;
			printf("L2   interface is [%.2x:%.2x:%.2x:%.2x:%2.2x:%.2x] with IP  %s\n\n", ((unsigned char)(attrs->ha[0])),  ((unsigned char)(attrs->ha[1])),  (unsigned char)(attrs->ha[2]), ((unsigned char) (attrs->ha[3])), ((unsigned char)(attrs->ha[4])), ((unsigned char)(attrs->ha[5])), inet_ntoa(ip));
		}
	}
 }
}
//function showing how to use the PICA capabilities in packet send/receive

void test_packet_io(void) {

	int i, j, size;
	char * aux; 
	char buf[2048]="sono il pachetto da inviare!!!";
	PICA_IO_DEVICE iodev;


  printf("\n------------------ Packet send and receive test -----------------\n");
  printf("interface used: %s\n",devs.dev_names[2]);

	aux = devs.dev_names[2]; //name of the interface used to send packets


	//Initialize packet data

	ZeroMemory(buf,255);

	buf[0] = 0x00;
	buf[2] = 0xFF;
	buf[3] = 0xFF;
	buf[4] = 0x42;
	buf[5] = 0xFF;

	buf[6] = 0x00;
	buf[1] = 0x20;
	buf[7] = 0x02;
	buf[8] = 0x2D;
	buf[9] = 0x08;
	buf[10] = 0x42;
	buf[11] = 0x73;


	buf[6] = 0x00;
	buf[7] = 0x04;
	buf[8] = 0x76;
	buf[9] = 0x0B;
	buf[10] = 0xE7;
	buf[11] = 0x4A;



	if (!PICAopenDevice(aux, &iodev)) printf("Error opening device\n");
	else printf("Success opening device\n");


	if (!PICAframe(PICA_SEND, iodev, buf, 80, &size)) printf("Error sending packet\n");
	else printf("Packet sent\n");


	
	//ZeroMemory(buf,2048);

	for (j=0;j<1;j++) {
		
		if (!PICAframe(PICA_RECEIVE, iodev, buf, 80, &size)) printf("Error receiving packet\n");
		else {
			printf("Packet received with size: %d\n",size);
			for (i=0;i<size;i++) {
				printf("%x ", (unsigned char) buf[i]);
			}
			printf("\n");

			printf("recived packet: %s", buf);
		}

	}//fim while

	if (!PICAcloseDevice(iodev)) printf("Error closing device\n");
	else printf("Success closing device\n");


}

//function showing how to use the PICA threads, mutexes and semaphores

void test_thread(void) {

   THRID mythr;
   int res;


   printf("\n------------------ Thread synchronization test -----------------\n");

  if (!PICAcreateMutex(&mymut)) {
	    printf("Error creating mutex\n");
		return;
   }

	if (!PICAmutexAction(MUTEX_ACQUIRE, &mymut)) printf("Error acquiring mutex\n");
	else printf("Mutex acquired in main\n");
  
	if (!PICAcreateSemaphore(&mysem, 3, 5)) {
		printf("Error creating semaphore\n");
		return;
	} else printf("Success creating semaphore\n");

	if (!PICAstartThread(&mythr, &thrfunc, "parametro")) printf("Error starting thread!\n");
	else {
		printf("Success starting thread\n");
	}


	Sleep(2000);

	if (!PICAmutexAction(MUTEX_RELEASE, &mymut)) printf("Error releasing mutex\n");
	else printf("Mutex released in main\n");

	Sleep(2000);

	if (!PICAsemaphoreAction(SEMAPHORE_RELEASE, &mysem,1)) printf("Error releasing sem\n");
	else printf("Sem. released in main\n");

/*printf("I'm going to sleep 2 sec.\n");
  Sleep(2000);
printf("I'm wakeup.\n");
  
  res=PICAsuspendThread(mythr);
  printf("res: %d\n", res);
  printf("Suspending for 2 sec.I'm going to sleep for 2 sec\n");
  Sleep(2000);
  printf("I'm wakeup.Resuming thread \n");
  PICAresumeThread(mythr);

  */
	Sleep(4000);
  printf("I'm going to kill thread\n");
 
  if (!PICAkillThread(mythr)) printf("Error stopping thread!");
  else printf("Thread stopped\n");

	Sleep(2000);
	
	if (!PICAdestroyMutex(&mymut)) printf("Error destroying mutex\n");
	else printf("Success destroying mutex\n");

	if (!PICAdestroySemaphore(&mysem)) printf("Error destroying semaphore\n");
	else printf("Success destroying semaphore\n");

}



//function showing how to use the PICA logging capabilities

void test_log(void) {
 FDesc myfile;
 char data[] = "33333333333333333333333";
// char buf[5];
 char *buf, *aux;
 int size, err;

 printf("\n------------------ Log file test -----------------\n");

//buf= (char *)GlobalAlloc(GMEM_FIXED, 20*sizeof(char));

 buf= (char *)malloc( 5*sizeof(char));
 if (!PICAopenFile(&myfile,"test.txt", WRITEF, CREATE_CLEAN)) {
	 printf("Error opening file\n");
	 return;
 } else printf("File open\n");

 if (!PICAwriteToFile(myfile,data, strlen(data)))
 {
	 PICAgetLastError(buf, &err);
	 printf("Error writing to file: %s %d", buf, err);
	 return;
 } else printf("Data written to file:-- %s-- \n", data);

 if (!PICAcloseFile(myfile)) printf("Error closing file");
  else printf("File closed\n");


  if (!PICAopenFile(&myfile,"test.txt", READF, 0)) {
	 printf("Error opening file\n");
	 return;
  } else printf("File open\n");


 if (!PICAreadFile(myfile,buf, 10, &size)) {
	 printf("Error reading file\n");
	 return;
 } else {
	 printf("SIZE: %d", size);
	 *(buf+size) = '\0';
	 printf("Data from file: %s\n", buf);
 }

 if (!PICAcloseFile(myfile)) printf("Error closing file");
else printf("File closed\n");

} 
/*
int test_router(int on_off) {

	OVERLAPPED	Overlapped;
	HANDLE		Handle;
	DWORD		dwCount;

	memset(&Overlapped,0, sizeof(OVERLAPPED));
	Overlapped.hEvent = CreateEvent(NULL, FALSE, FALSE, NULL);

	if (on_off == FWD_ON) {
		if (EnableRouter(&Handle, &Overlapped) != ERROR_IO_PENDING) {
			printf("PICAsetForwarding: Error setting forwarding state\n");
			return 0;
		}
	}
	else {
		if (UnenableRouter(&Overlapped, &dwCount) != NO_ERROR) {
			printf("PICAsetForwarding: Error setting forwarding state\n");
			return 0;
		}
	}

	return 1;
}
*/


void thrfunc2(void * data) {
  char * dados;

  dados = (char *) data;

  printf("Dados da thread: %s\\n",dados);

	while(1) {
		printf("in the thread!\n");
		Sleep(1000);
	}

}

void test_create_thread(void) {

   THRID mythr;
   int res;


   printf("\n------------------ Create Thread test -----------------\n");


	if (!PICAstartThread(&mythr, &thrfunc2, "parametro")) printf("Error starting thread!\n");
	else {
		printf("Success starting thread\n");
	}

printf("I'm going to sleep 2 sec.\n");
  Sleep(2000);
printf("I'm wakeup.\n");
  
  res=PICAsuspendThread(mythr);
  printf("res: %d\n", res);
  printf("Suspending for 2 sec.I'm going to sleep for 2 sec\n");
  Sleep(2000);
  printf("I'm wakeup.Resuming thread \n");
  PICAresumeThread(mythr);
  printf("I'm going to kill thread\n");
 printf("I'm going to sleep 2 sec.\n");
  Sleep(2000);
printf("I'm wakeup.\n");
  if (!PICAkillThread(mythr)) printf("Error stopping thread!");
  else printf("Thread stopped\n");

	
}



/*
------------------------- Main ------------------------------
*/


int main (void) {

 PICAsocket mysock;
 int adm, code;
 char buf[100];


 //Library startup is very important !!!!
  if (!PICAstartup(0)) printf("Error starting library\n");
  else printf("PICA library initialized!\n\n");

//blocking spcket creation
  if (!PICAcreateSocket(&mysock,PF_INET, SOCK_DGRAM, 0, 2)) printf("Error creating socket\n");
  else printf("socket created\n");
  if (!PICAcloseSocket(mysock)) printf("Error closing socket\n");
  else printf("Socket closed\n");

   if (!PICAisAdministrator(&adm)) printf("Error getting ADM. data\n");
   else printf("Success getting ADM. data: user is %s\n",adm>0?"Administrator":"not Administrator");

test_devices();		
   test_rtable();

     /* printf("second time:\n");
if (PICAdelRoute(inet_addr("240.0.0.0"),inet_addr("240.0.0.0"),inet_addr("158.42.55.152"),"{B9BF0A0F-15FC-4842-86E3-9D440A23BC4A}")) printf("Success removing route\n");
  else
  {
	PICAgetLastError(buf,&code);
	  printf("Error deleting RT: %s\n",buf);
	  if(code==ERROR_NOT_FOUND)
		  printf("entri not found\n");
	  else
		  printf("altro errore\n");
	}*/
	test_devices();	
   test_rtable();
/*	test_devices();	

	test_buffering();	

	test_forwarding();
	
	test_TTL();

	test_rtable();
	
	test_timer();
	
	test_pipe();

   test_log();

	test_select(); //DA RIVEDERE

	test_thread();
   //test_create_thread();


	//test_packet_io(); //non l'ho potuto fare --> errore
*/	

	if (!PICAcleanup()) printf("Error cleaning library\n");
	else printf("\nPICA library cleaned up!\n");
/*
	test_forwarding();
	printf("Enabling router\n");
	if (test_router(1)==1) {
		test_forwarding();
	} else printf("Error starting router\n");

	printf("Disabling router\n");
	if (test_router(0)==1) {
		test_forwarding();
	} else printf("Error starting router\n");
	*/
	printf("End testing!!! \n");
   getchar();

}
