/*****************************************************************************
 *
 * Copyright (C) 2002 Polytechnic University of Valencia.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Authors: Carlos Calafate, <calafate@disca.upv.es>
 *
 *****************************************************************************/

#ifndef _TIMER_H
#define _TIMER_H


#define _WIN32_WINNT 0x0500

#include "PICAspec.h"


#include <stdlib.h>
#include <stdio.h>
#include <signal.h>
#include <sys/timeb.h>




/* How much the currtime can diverge from set time to match (in ms)*/
#define TIME_DIV 100

typedef unsigned __int64 UINT64;

#define T_SET 0
#define T_STOP 1
#define T_STARTUP 2
#define T_KILL 3

UINT64 PICAgetCurrTime(void);

int PICAtimer(int action, UINT64 * time, void * function, void * data);


/* prio queue entry */
struct prioqent
{
  UINT64 tv;  /* Time the event should happend in ms since 1 jan 1970 */
  void (*callback)(void *);
  void *data;    /* Data stored in the entry */
//  unsigned int id;  /* An id used to match one or a group of entrys */
//  unsigned char flags;  /* Flag which represents what's in the dataportion */
  struct prioqent *pqe;  /* A pointer to the next entry in the list */
};

/* The prio queue */
struct prioq
{
  struct prioqent *pqe;  /* Pointer to the first entry */
//  HANDLE tpipe[2];          /* The pipe used to communicate with top program */
};

struct itimerval {
	struct timeval it_interval;
	struct timeval it_value;
};



struct prioqent * pq_getfromqueue(UINT64 * time,void * function);

void pq_cleanup(void);


int pq_insert(UINT64 msec,void (*func)(void *),void * data);
 
void pq_signal(int signal);
 
void pq_updatetimer();
struct prioqent *pq_getfirst();
void pq_deleteent(struct prioqent *pqed);
void pq_unqueuefirstent();
void pq_deletefirstent();
struct prioqent *pq_getfirstdue(UINT64 tv);


#endif

