/*****************************************************************************
 *
 * Copyright (C) 2002 Polytechnic University of Valencia.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Authors: Carlos Calafate, <calafate@disca.upv.es>
 *
 *****************************************************************************/

#ifndef _RTMANAGER_H
#define _RTMANAGER_H


#include "PICAspec.h"

#include <Iphlpapi.h>
#include <Iprtrmib.h>
#define MPR50 1
#include <Routprot.h>
#include <string.h>



#define BUFSIZE 3000

typedef struct _RTLines {
        UINT32 dest;
        UINT32 mask;
        UINT32 gw;
        int metric;
        char * device;
        struct _RTLines * next;
} RTLines;

typedef struct _RTInfo {
        int entry_count;
        RTLines * lines;
} RTInfo;


int PICAaddRoute(UINT32 dest, UINT32 mask, UINT32 gateway,int metric, char * device);
int PICAdelRoute(UINT32 dest, UINT32 mask, UINT32 gateway, char * device);
int PICAgetRoutingTable(RTInfo * rti);


#endif