#include "PICA/user.h"

int PICAisAdministrator(int * true_false) {
	char uname[UNLEN+1];
	LPCWSTR uname2;
	int size;
	LPUSER_INFO_1 pBuf = NULL;
	NET_API_STATUS nStatus;

	if (true_false == NULL) {
		P_ERROR("PICAisAdministrator: user variable points to NULL", 100101);
		return 0;
	}



	*true_false =  0;

	size = 2*(UNLEN+2);
	if ((uname2 = (LPCWSTR) malloc(size)) == NULL) {
		P_ERROR("PICAisAdministrator: Unable to allocate memory", 100102);
		return 0;
	}
	
	if (GetUserName(uname,&size) == 0) {
		P_ERROR("PICAisAdministrator: Error getting user name", 100103);
		return 0;
	}

	if (MultiByteToWideChar(CP_THREAD_ACP,MB_PRECOMPOSED,uname,-1,uname2,500) == 0){
		P_ERROR("PICAisAdministrator: Error converting to Wide Char", 100104);		
		return 0;
	}

   nStatus = NetUserGetInfo(NULL,uname2,1,(LPBYTE *)&pBuf);
   if (nStatus != NERR_Success) {
		P_ERROR("PICAisAdministrator: Error getting user info", 100105);			   
		return 0;
   }
   else {
	if (pBuf->usri1_priv == USER_PRIV_ADMIN) *true_false =  1;
   }

   free(uname2);
   return 1;
}

