// test2Dlg.cpp : file di implementazione
//

#include "stdafx.h"
#include "test2.h"
#include "test2Dlg.h"
#include "PICA/pica.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


PICAmutex mymut;
PICAsemaphore mysem;


// finestra di dialogo Ctest2Dlg

Ctest2Dlg::Ctest2Dlg(CWnd* pParent /*=NULL*/)
	: CDialog(Ctest2Dlg::IDD, pParent)
	, m_text(_T(""))
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void Ctest2Dlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Text(pDX, IDC_EDIT1, m_text);
}

BEGIN_MESSAGE_MAP(Ctest2Dlg, CDialog)
#if defined(_DEVICE_RESOLUTION_AWARE) && !defined(WIN32_PLATFORM_WFSP)
	ON_WM_SIZE()
#endif
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_BUTTON1, &Ctest2Dlg::OnBnClickedButton1)
	ON_BN_CLICKED(IDC_PIPE, &Ctest2Dlg::OnBnClickedPipe)
	ON_BN_CLICKED(IDC_FORW, &Ctest2Dlg::OnBnClickedForw)
	ON_BN_CLICKED(IDC_RTAB, &Ctest2Dlg::OnBnClickedRtab)
	ON_BN_CLICKED(IDC_DEVS, &Ctest2Dlg::OnBnClickedDevs)
	ON_BN_CLICKED(IDC_LOG, &Ctest2Dlg::OnBnClickedLog)
	ON_BN_CLICKED(IDC_SELECT, &Ctest2Dlg::OnBnClickedSelect)
	ON_BN_CLICKED(IDC_THREAD, &Ctest2Dlg::OnBnClickedThread)
	ON_BN_CLICKED(IDC_THRMUTEX, &Ctest2Dlg::OnBnClickedThrmutex)
	ON_BN_CLICKED(IDC_TIMER, &Ctest2Dlg::OnBnClickedTimer)
END_MESSAGE_MAP()


// gestori di messaggi Ctest2Dlg

BOOL Ctest2Dlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Impostare l'icona per questa finestra di dialogo. Il framework non esegue questa operazione automaticamente
	//  se la finestra principale dell'applicazione non  una finestra di dialogo.
	SetIcon(m_hIcon, TRUE);			// Impostare icona grande.
	SetIcon(m_hIcon, FALSE);		// Impostare icona piccola.

#ifdef WIN32_PLATFORM_WFSP
	if (!m_dlgCommandBar.Create(this) ||
	    !m_dlgCommandBar.InsertMenuBar(IDR_MAINFRAME))
	{
		TRACE0("Impossibile creare CommandBar\n");
		return FALSE;      // impossibile creare
	}
#endif // WIN32_PLATFORM_WFSP
	// TODO: aggiungere qui inizializzazione aggiuntiva.
	
	return TRUE;  // restituisce TRUE a meno che non venga impostato lo stato attivo su un controllo.
}

#if defined(_DEVICE_RESOLUTION_AWARE) && !defined(WIN32_PLATFORM_WFSP)
void Ctest2Dlg::OnSize(UINT /*nType*/, int /*cx*/, int /*cy*/)
{
	DRA::RelayoutDialog(
		AfxGetInstanceHandle(), 
		this->m_hWnd, 
		DRA::GetDisplayMode() != DRA::Portrait ? 
			MAKEINTRESOURCE(IDD_TEST2_DIALOG_WIDE) : 
			MAKEINTRESOURCE(IDD_TEST2_DIALOG));
}
#endif

void Ctest2Dlg::printf(char * data)
{
	unsigned short wides[1024];		

	MultiByteToWideChar(CP_ACP,MB_PRECOMPOSED,data,-1,(LPWSTR)wides,1024);

	m_text.Format(L"%s%s\r\n",m_text,wides);
	UpdateData(FALSE);
}

void Ctest2Dlg::OnBnClickedButton1()
{
	int adm; //1		
	PICAsocket mysock;

	  m_text = L"";	

	  printf("Inicio");

	  if (!PICAisAdministrator(&adm)) printf("Error getting ADM. data");
	  else 
	  {
		  sprintf(text,"Success getting ADM. data: user is %s",adm>0?"Administrator":"not Administrator");
		  printf(text);
	  }
  //non blocking socket creation
	  if (!PICAcreateSocket(&mysock,PF_INET, SOCK_DGRAM, 0, NO_BLOCK)) printf("Error creating socket");
	  else printf("socket created");
	  if (!PICAcloseSocket(mysock)) printf("Error closing socket");
	  else printf("Socket closed");
}

void Ctest2Dlg::OnBnClickedPipe()
{
	PICApipe inpipe, outpipe;
	unsigned char pdata[] = "Os meus dados", buf[512];
	int len, ret;

  PICAbuffer * pbuf;
  PICApacket * packets;
  char  buf1[] = "Dados do buffer1";
  char  buf2[] = "Dados do buffer2";
  char  buf3[] = "Dados do buffer3";
  int size, i, avail_packets;

	m_text = L"";	
printf("--- TEST PIPE---");
     if (!PICAmakePipe(&inpipe, &outpipe)) printf("Error making pipe");
     else printf("Success opening pipes");
 
	 len = 14;
     if (!PICAsendToPipe(outpipe, pdata, len, &ret)) printf("Error sending");        
	 else printf("Sent bytes");

     if (!PICAgetFromPipe(inpipe, buf, 512, &ret)) printf("Error receiving");
     else {
            buf[ret] = '\0';
            sprintf(text,"received %d bytes: %s",ret,buf);
			printf(text);
     }

     if (!PICAclosePipe(inpipe)) printf("Error closing pipe");
     else printf("Closed pipe");
     if (!PICAclosePipe(outpipe)) printf("Error closing pipe");
     else printf("Closed pipe");		


	 //////////////////
printf("--- TEST BUFFER---");

	 if (!PICAinitBuffer(&pbuf, 3)) printf("Error starting buffer");
	 else printf("Buffer initiated");	

  size = strlen(buf1);
  
  if (!PICAaddToBuffer(pbuf,0, buf1, size)) printf("Error adding to buffer");
  else printf("Added data to buffer");

 if (!PICAaddToBuffer(pbuf,1, buf1, size)) printf("Error adding to buffer");
  else printf("Added data to buffer");

 if (!PICAaddToBuffer(pbuf,2, buf3, size)) printf("Error adding to buffer");
  else printf("Added data to buffer");



 for (i=0;i<3;i++) {
  
   sprintf(text,"Getting row %d",i);
   printf(text);

   if (!PICAgetFromBuffer(pbuf, i, 3, &packets,&avail_packets)) printf("Error getting from buffer\n");
   else {
	   sprintf(text,"Got data from buffer: %d packets",avail_packets);
	   printf(text);
   }

   if (packets == NULL) printf ("packets is null");

   while (packets != NULL) {
//     ((char *)packets->data)[packets->packet_size - 1] = '\0';
	   sprintf(text, "Size:%d Data: %s",(char *) packets->packet_size,(char *) packets->data);
	 printf(text);
     packets = packets->next;
   }
   
 }


 if (!PICAkillBuffer(pbuf)) printf("Error killing buffer");
  else printf("Buffer killed");
}

void Ctest2Dlg::OnBnClickedForw()
{
	int tf;
  int ttl;
  char msg[128];
  int err, e;

	LPVOID lpMsgBuf;
	DWORD ret;
	MIB_IPSTATS lstats;

	  m_text = L"";	

	//using PICA
	if (!PICAdefaultTTL(TTL_GET, &ttl))
	{
		PICAgetLastError(msg, &err);
		sprintf(text,"TTL: %s num err:%d",msg, err);  		
		printf(text);
	}
	else
	{
		sprintf(text,"TTL is %d",ttl);
		printf(text);			
	}

	ttl++;

	printf("add 1 to preview TTL value");
	if (!PICAdefaultTTL(TTL_SET, &ttl)) 
	{
		PICAgetLastError(msg, &err);
		sprintf(text,"TTL: %s num err:%d",msg, err);  		
		printf(text);
	}

	else
	{
		sprintf(text,"TTL set to %d",ttl);
		printf(text);			
	}

	if (!PICAdefaultTTL(TTL_GET, &ttl)) printf("Error getting TTL");
	else
	{
		sprintf(text,"TTL is %d",ttl);
		printf(text);			
	}

	if (!PICAisForwarding(&tf)) printf("PICAisForwarding: Error getting forwarding state");
	else
	{
		sprintf(text,"Forwarding is %s",tf>0?"ON":"OFF");
		printf(text);		
	}
  
if(tf>0)//if forwarding is on
{

  if (!PICAsetForwarding(FWD_OFF)) printf("PICAisForwarding:Error stopping forwarding");
  else
  {
	if (!PICAisForwarding(&tf)) printf("PICAisForwarding:Error getting forwarding state");
	else
	{
		sprintf(text,"Forwarding is %s",tf>0?"ON":"OFF");
		printf(text);		
	}
  }
}
else
{
  if (!PICAsetForwarding(FWD_ON)) printf("PICAisForwarding:Error starting forwarding");
  else
  {
	if (!PICAisForwarding(&tf)) printf("PICAisForwarding: Error getting forwarding state");
	else
	{
		sprintf(text,"Forwarding is %s",tf>0?"ON":"OFF");
		printf(text);		
	}
  }
}
}

void Ctest2Dlg::OnBnClickedRtab()
{
	char buf[128];
	int adm;
	 RTInfo rt;
	RTLines * line;
	struct in_addr dest,mask,gw;
	char s_dest[16], s_mask[16], s_gw[16];

	DEVLIST devs;
	int i;
	DevAttrs attrs;
	struct in_addr ip;


	m_text = L"";	





	m_text = L"";	

	if (!PICAgetAvailableDevices(&devs)) printf("Error getting devices");
	else {
		sprintf(text, "Devices:%d",devs.num_devices);
		printf(text);
		for (i=0;i<devs.num_devices;i++) {
			sprintf(text,"Device: %s", devs.dev_names[i]);
			printf(text);
			PICAgetDeviceAttrs(devs.dev_names[i], &attrs);
			ip.s_addr = attrs.ip_addr;
			sprintf(text,"IP: %s MAC: %2.2X:%2.2X:%2.2X:%2.2X:%2.2X:%2.2X", inet_ntoa(ip),attrs.ha[0],attrs.ha[1],attrs.ha[2],attrs.ha[3],attrs.ha[4],attrs.ha[5]);
			printf(text);


  if (PICAaddRoute(inet_addr("192.168.0.13"),inet_addr("255.255.255.255"),inet_addr("192.168.0.1"),1,devs.dev_names[i])) printf("Sucess adding route");
  else {
	  PICAgetLastError(buf,&adm);
	    sprintf(text,"Error adding route: %s",buf);  		
		printf(text);			 
  }

  if (!PICAgetRoutingTable(& rt)) {
		PICAgetLastError(buf,&adm);
	  sprintf(text,"Error reading RT: %s",buf);
	  printf(text);		
  }
  else {
	printf("Success reading RT");
  
	sprintf(text,"Linhas: %d", rt.entry_count);
	printf(text);		
	sprintf(text,"\tdest\t\tmask\t\tgw\tmetric\tif"); 
	printf(text);		
	line = rt.lines;
    while (line != NULL) {
		dest.s_addr = line->dest;
		strcpy(s_dest,inet_ntoa(dest));
		mask.s_addr = line->mask;
		strcpy(s_mask,inet_ntoa(mask));
		gw.s_addr = line->gw;
		strcpy(s_gw,inet_ntoa(gw));
		sprintf(text,"%14s\t%14s\t%14s\t%3d\t%4s",s_dest,s_mask,s_gw,line->metric,line->device);
		printf(text);		
		line = line->next;
	  }	  
  }
	
  printf("");
  if (PICAdelRoute(inet_addr("192.168.0.13"),inet_addr("255.255.255.255"),inet_addr("192.168.0.01"),devs.dev_names[i])) printf("Success removing route");
  else printf("Error removing route");

  		}
	}

}

void Ctest2Dlg::OnBnClickedDevs()
{
	DEVLIST devs;
	int i;
	DevAttrs attrs;
	struct in_addr ip;
	char msg[100];
	int err=0;

	m_text = L"";	

	if (!PICAgetAvailableDevices(&devs))
	{
		PICAgetLastError(msg, &err);
		sprintf(text, "E: %d : %s", err, msg);
		printf(text);
	}
	else {
		printf("Devices:");
		for (i=0;i<devs.num_devices;i++) {
			sprintf(text,"Device: %s", devs.dev_names[i]);
			printf(text);
			PICAgetDeviceAttrs(devs.dev_names[i], &attrs);
			ip.s_addr = attrs.ip_addr;
			sprintf(text,"IP: %s MAC: %2.2X:%2.2X:%2.2X:%2.2X:%2.2X:%2.2X", inet_ntoa(ip),attrs.ha[0],attrs.ha[1],attrs.ha[2],attrs.ha[3],attrs.ha[4],attrs.ha[5]);
			printf(text);
		}
	}
}

void Ctest2Dlg::OnBnClickedLog()
{
	FDesc myfile;
	char buf[20], dados[] = "hola!! ";	
	int size, err;
	char msg[100];


	 m_text = L"";	

	if (!PICAopenFile(&myfile,"\\mig.txt",WRITEF, APPEND)) printf("Error opening file");
	else {
		if (!PICAwriteToFile(myfile, dados, strlen(dados))) printf("Error wrinting\n");
		else printf("Data written");
		if (!PICAcloseFile(myfile)) printf("Error closing file");
	}


	if (!PICAopenFile(&myfile,"\\mig.txt",READF, 0)) printf("Error opening file");
	else {
		if (!PICAreadFile(myfile, buf, 20, &size)) {
			PICAgetLastError(msg,&err);
			sprintf(text,"Error reading file (%d): %s",err, msg);  		
			printf(text);			 
//			printf("Error reading\n");
		}
		else {			
			sprintf(text,"Data read: %d bytes",size);
			printf(text);		
			/*if (size > 0) {				
				buf[size] = '\0';
				//buf[size+1] = '\0';
				sprintf(text,"%s", buf);
				printf(text);			
			}*/
		}



		if (!PICAcloseFile(myfile)) 
		{
			PICAgetLastError(msg,&err);
			sprintf(text,"Error cloasing file (%d): %s",err, msg);  		
			printf(text);			 
		}
		else printf("file closed!");
	}


/*
	CloseHandle(myfile);

		FormatMessage(FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM | FORMAT_MESSAGE_IGNORE_INSERTS, NULL,  GetLastError(), 0, (LPTSTR) &lpMsgBuf, 0, NULL);

	MessageBox((LPCTSTR)lpMsgBuf,L"Error",MB_OK);
		
	// Free the buffer.
	LocalFree( lpMsgBuf );
*/
}

void Ctest2Dlg::OnBnClickedSelect()
{
	HANDLE myevent, myevent2;
	PICAsocket mysock;
	PICAdescList * dl, * jump, * run;
	PICAselResult res;
	PICApipe in, out;
	char buf[100] = "Data sent to pipe";
	int code, written, retval;

	
	myevent = CreateEvent(NULL,FALSE,FALSE,NULL);
	myevent2 = CreateEvent(NULL,FALSE,FALSE,NULL);
	SetEvent(myevent2);

	if (!PICAmakePipe(&in, &out)) printf("Error creating pipe\n");
	else printf("pipe created");




if (!PICAcreateSocket(&mysock,PF_INET, SOCK_DGRAM, 0, 2)) printf("Error creating socket\n");
  else printf("socket created");
  


	printf("Starting select");

	dl = NULL;
		
	if (!PICAaddDesc(&dl, PICA_PIPE_TYPE, &in)) printf("Error adding descriptor\n");
	if (!PICAaddDesc(&dl, PICA_SOCKET_TYPE, &mysock)) printf("Error adding descriptor\n");
//	if (!PICAaddDesc(&dl, PICA_SOCKET_TYPE, &mysock)) printf("Error adding descriptor\n");
	if (!PICAaddDesc(&dl, PICA_OTHER_TYPE, &myevent)) printf("Error adding descriptor\n");
	if (!PICAaddDesc(&dl, PICA_OTHER_TYPE, &myevent2)) printf("Error adding descriptor\n");


//	printf("main: dl is %x\n",dl);
	

	if (! PICAselect(20, dl,  &res))
	{
		PICAgetLastError(buf,&code);		
		sprintf(text,"Error %d in PICAselect: %s\n",code, buf);
		printf(text);
	}
	else {

			printf("Success in select\n");
			if (res.type == PICA_TIMEOUT_TYPE) printf("Selection result is timeout\n");
			else if (res.type == PICA_PIPE_TYPE)
			{
				printf("Selection result of pipe type\n");
				sprintf(buf,"");
				PICAgetFromPipe(in, buf, 100, &written);
				buf[written] = '\0';
				sprintf(text,"Pipe activated. Data: %s\n",buf);
				printf(text);
			}
			else 
			{
				sprintf(text,"Results: type = %d desc= %x. event desc= %x\n",res.type,res.desc, &myevent2);
				printf(text);
			}
		
		}   	


	

	

  if (!PICAsendToPipe(out, buf, strlen(buf), &written)) printf("Error writing to pipe\n");
 
  SetEvent(myevent);


	if (!PICAselect(500, dl,  &res)) {
		PICAgetLastError(buf,&code);
		sprintf(text,"Error in PICAselect: %s\n", buf);
		printf(text);
	}
	else {
		printf("Success in select\n");
		if (res.type == PICA_TIMEOUT_TYPE) printf("Selection result is timeout\n");
		else if (res.type == PICA_PIPE_TYPE) {
			sprintf(buf,"");
			PICAgetFromPipe(in, buf, 100, &written);
			buf[written] = '\0';
			sprintf(text,"Pipe activated. Data: %s\n",buf);
			printf(text);
		}
		else {
			sprintf(text,"Results: type = %d desc= %x. event desc= %x\n",res.type,res.desc, &myevent);
			printf(text);
		}
	}
}


DWORD WINAPI thrfunc(void * data) {
	CString * texto;

	texto = (CString *) data;
	*texto += L"sono il thread: prima dl while!!\r\n";

	while (1) {
		*texto += L"sono il thread: dentro dl while!!\r\n";
		*texto += L"dormo\r\n";
		Sleep(1000);
		*texto += L"sveglio\r\n";
	}
	*texto += L"sono il thread: dopo dl while!!\r\n";
	return 0;
}
void Ctest2Dlg::OnBnClickedThread()
{
	PICAmutex mymut;
	PICAsemaphore mysem;
	char buf[1024];
	int code, i;
	THRID mythr;
	CString prova;

	m_text = L"";


	if (PICAstartThread(&mythr, &thrfunc, (void *) &m_text) == 0) printf("Error starting thread!");
  else {
    printf("Success starting thread");
  }
  for (i=0;i<10;i++) {
	  Sleep(200);
	  UpdateData(FALSE);  
  }
  printf("Suspending thread");
  if (!PICAsuspendThread(mythr)) printf("Error suspending thread");
  for (i=0;i<10;i++) {
	  Sleep(200);
  }
  UpdateData(FALSE); 
  
  
  printf("Resuming for 2 sec.");
  if (!PICAresumeThread(mythr)) printf("Error resuming thread");  
  for (i=0;i<10;i++) {
	  Sleep(200);
	  UpdateData(FALSE);  
  }
  UpdateData(FALSE);
  printf("trying to kill ");
  if (!PICAkillThread(mythr)) printf("Error stopping thread!");
  else printf("Thread stopped");
}


DWORD WINAPI thrfunc2(void * data) {
	CString * texto;

	texto = (CString *) data;
	*texto += L"sono il thread: prima dl while!!\r\n";


   // printf("Thread:Trying to acquire mutex\n");

	if (!PICAmutexAction(MUTEX_ACQUIRE, &mymut)) *texto += L"Error acquiring mutex in thread\r\n";
	else *texto += L"Mutex acquired in thread\r\n";
  
	*texto += L"Thread: Trying to acquire semaphore\r\n";
	if (!PICAsemaphoreAction(SEMAPHORE_ACQUIRE, &mysem,4)) *texto += L"Error acquiring sem. in thread\r\n";
	else *texto += L"Sem. acquired in thread\r\n";

	*texto += L"Thread: I'm working in critical session!!! :P \r\n";
    Sleep(2000);

	*texto += L"Thread: I ended to work in critical session!!! :P \r\n";
	if (!PICAmutexAction(MUTEX_RELEASE, &mymut)) *texto += L"Error releasing mutex\r\n";
	else *texto += L"Mutex released in thread\r\n";

	if (!PICAsemaphoreAction(SEMAPHORE_RELEASE, &mysem,1)) *texto += L"Error releasing sem\r\n";
	else *texto += L"Sem. released in thread\r\n";

	Sleep(2000);

		while (1) {
		*texto += L"sono il thread: dentro dl while!!\r\n";
		*texto += L"dormo\r\n";
		Sleep(1000);
		*texto += L"sveglio\r\n";
	}
	*texto += L"sono il thread: dopo dl while!!\r\n";

	return 0;
}


void Ctest2Dlg::OnBnClickedThrmutex()
{
	THRID mythr;
 int i;


   printf("\n------------------ Thread synchronization test -----------------\n");

m_text = L"";

  if (!PICAcreateMutex(&mymut)) {
	    printf("Error creating mutex\n");
		return;
   }
  else printf("Mutex created in main\n");

	if (!PICAmutexAction(MUTEX_ACQUIRE, &mymut)) printf("Error acquiring mutex\n");
	else printf("Mutex acquired in main\n");
  
	if (!PICAcreateSemaphore(&mysem, 3, 5)) {
		printf("Error creating semaphore\n");
		return;
	} else printf("Success creating semaphore\n");


	if (!PICAstartThread(&mythr, &thrfunc2, (void *) &m_text)) printf("Error starting thread!\n");
	else {
		printf("Success starting thread\n");
	}

 for (i=0;i<10;i++) {
	  Sleep(200);
	  UpdateData(FALSE);  
  }

	if (!PICAmutexAction(MUTEX_RELEASE, &mymut)) printf("Error releasing mutex\n");
	else printf("Mutex released in main\n");

for (i=0;i<10;i++) {
	  Sleep(200);
	  UpdateData(FALSE);  
  }

	if (!PICAsemaphoreAction(SEMAPHORE_RELEASE, &mysem,1)) printf("Error releasing sem\n");
	else printf("Sem. released in main\n");

for (i=0;i<20;i++) {
	  Sleep(200);
	  UpdateData(FALSE);  
  }
  printf("I'm going to kill thread\n");
 
  if (!PICAkillThread(mythr)) printf("Error stopping thread!");
  else printf("Thread stopped\n");
	

for (i=0;i<10;i++) {
	  Sleep(200);
	  UpdateData(FALSE);  
  }
	if (!PICAdestroyMutex(&mymut)) printf("Error destroying mutex\n");
	else printf("Success destroying mutex\n");

	if (!PICAdestroySemaphore(&mysem)) printf("Error destroying semaphore\n");
	else printf("Success destroying semaphore\n");

}

DWORD WINAPI timerfunc(void * data) {
	CString * texto;

	texto = (CString *) data;
	printf((char*)data);

    *texto += L"I'm timerfunc. Timer activated\r\n";

	return 0;
}



void Ctest2Dlg::OnBnClickedTimer()
{
	UINT64 dif;
	UINT userval;
	int i,j,k;
	



	char buf[256];
	unsigned short widep[256];
	int code;
	char  buf5[] = "Dados do buffer5";
	char  buf6[] = "Dados do buffer6";
	

//	event = CreateEvent(NULL,FALSE,FALSE,NULL);
/*
	UpdateData(TRUE);
	
	m_text.Format(_T("Sleeping for: %d\r\n"), m_time);	
	UpdateData(FALSE);
	
	curr_time = PICAgetCurrTime();	
	WaitForSingleObject(event,m_time);
*/

	//PICAstartup(0);
/*
	userval = GetTickCount();
	
	userval2 = userval % 1000;

	m_text.Format(_T("%d-%d ms\r\n"), userval,userval2);	
	UpdateData(FALSE);
*/

/*
	dif = PICAgetCurrTime();

	dif += 3000;

	printf(L"Setting timer");

	if (!PICAtimer(T_STARTUP, NULL, NULL, NULL)) printf(L"Error starting timer");
	else printf(L"Success starting timer");


	if (!PICAtimer(T_SET, &dif, (void *) timerfunc, buf6)) {	
		printf(L"Error setting timer");
	}
	else printf(L"Success setting timer");

	dif -=1500;

	if (!PICAtimer(T_SET, &dif, (void *) timerfunc, buf5)) printf(L"Error setting timer");
	else printf(L"Success setting timer");

	if (!PICAtimer(T_STOP, &dif, (void *) timerfunc, buf5)) printf(L"Error stopping timer");
	else printf(L"Success stopping timer");

	if (!PICAtimer(T_KILL, NULL, NULL, NULL)) {
		printf(L"Error killing timer");
		PICAgetLastError(buf,&code);
		MultiByteToWideChar(CP_ACP,MB_PRECOMPOSED,buf,-1,widep, 256);
		m_text.Format(_T("%s%s:\r\n%d\r\n"),m_text, widep,code);	
		UpdateData(FALSE);
	}
	else printf(L"Success killing timer");
*/


dif = PICAgetCurrTime();

	dif += 3000;
//	dif += -10;

	if (!PICAtimer(T_STARTUP, NULL, NULL, NULL)) printf("Error starting timer");
	else printf("Success starting timer");

	if (!PICAtimer(T_SET, &dif, (void *) timerfunc, buf5)) printf("Error setting timer");
	else printf("Success setting timer");

	if (!PICAtimer(T_STOP, &dif, (void *) timerfunc, buf5)) printf("Error stopping timer");
	else printf("Success stopping timer");
/*
	if (WaitForSingleObject(event,5000) == WAIT_OBJECT_0) {
		printf("timer activated");
		m_text.Format(_T("%sdif:%d\r\n"),m_text, PICAgetCurrTime() - dif);	
		UpdateData(FALSE);
	}
*/
	Sleep(5000);
	UpdateData(FALSE);


	dif = PICAgetCurrTime();

	dif += 3000;

	if (!PICAtimer(T_SET, &dif, (void *) timerfunc, (void *) &m_text)) printf("Error setting timer\n");
	else printf("Success setting timer");

	if (!PICAtimer(T_SET, &dif, (void *) timerfunc, (void *) &m_text)) printf("Error setting timer\n");
	else printf("Success setting timer");

	dif += 3000;

	if (!PICAtimer(T_SET, &dif, (void *) timerfunc, (void *) &m_text)) printf("Error setting timer\n");
	else printf("Success setting timer");

	for (i=0;i<50;i++) {
		Sleep(200);
		UpdateData(FALSE);
	}


//	userval = GetTickCount();
//	while ((userval2 = GetTickCount()) == userval) ;

//	m_text.Format(_T("%sPrimero: %d\r\nSegundo: %d\r\n"),m_text, userval, userval2);	
//	UpdateData(FALSE);

	if (!PICAtimer(T_KILL, NULL, NULL, NULL)) {
		printf("Error killing timer");
		PICAgetLastError(buf,&code);
		MultiByteToWideChar(CP_ACP,MB_PRECOMPOSED,buf,-1,(LPWSTR)widep, 256);
		m_text.Format(_T("%s%s:\r\n%d\r\n"),m_text, widep,code);	
		UpdateData(FALSE);
	}
	else printf("Success killing timer");

	printf("fin");
	
}