/*****************************************************************************
 *
 * Copyright (C) 2002 Polytechnic University of Valencia.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Authors: Carlos Calafate, <calafate@disca.upv.es>
 *
 *****************************************************************************/

#ifndef _LOG_H
#define _LOG_H

#include "PICAspec.h"

//to be used for parameter read_write
#define READF 0
#define WRITEF 1
#define READF_WRITEF 2

typedef HANDLE FDesc;

//para flags
#define CREATE_CLEAN 0
#define APPEND 1

int PICAopenFile(FDesc * file, char * name, int read_write, int flags);
int PICAwriteToFile(FDesc file, void * data, unsigned int datasize);
int PICAreadFile(FDesc file, void * buf, int buffersize, int * datasize);
int PICAcloseFile(FDesc file);

int PICAgetTimeStr(char ** time_str);

#endif