/*****************************************************************************
 *
 * Copyright (C) 2002 Polytechnic University of Valencia.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Authors: Carlos Calafate, <calafate@disca.upv.es>
 *          Valentina Gaggero, <valentina.gaggero@libero.it>
 *
 *****************************************************************************/

#ifndef _THR_H
#define _THR_H

#include "PICAspec.h"


#define PICA_SOCKET_TYPE 0
#define PICA_PIPE_TYPE 1
#define PICA_OTHER_TYPE 2
#define PICA_TIMEOUT_TYPE 255

#define PICA_WAIT_FOREVER -1

#define PICA_W_READ 0
#define PICA_W_WRITE 1
#define PICA_W_EXC 2

#define MUTEX_ACQUIRE 0
#define MUTEX_RELEASE 1
#define MUTEX_ACQ_NO_BLOCK 2

#define SEMAPHORE_ACQUIRE 0
#define SEMAPHORE_RELEASE 1
#define SEMAPHORE_ACQ_NO_BLOCK 2



typedef HANDLE THRID;
typedef HANDLE PICAmutex;
typedef HANDLE PICAsemaphore;

typedef struct _PICAdescList {
	int type;
	void * desc;
	struct _PICAdescList * next;
} PICAdescList;

typedef struct _PICAselResult {
	int type;
	void * desc;
} PICAselResult;


int PICAstartThread(THRID * thr, void * func, void * arg);

int PICAsuspendThread(THRID thr);

int PICAresumeThread(THRID thr);

int PICAkillThread(THRID thr);

int PICAselect(int time, PICAdescList * dl, PICAselResult * res);

int PICAaddDesc(PICAdescList ** dl, int type, void * desc);

int PICAcreateMutex(PICAmutex * mut);

int PICAmutexAction(int action, PICAmutex * mut);

int PICAdestroyMutex(PICAmutex * mut);

int PICAcreateSemaphore(PICAsemaphore * p_sem, int initial_count, int max_count);

int PICAsemaphoreAction(int action, PICAsemaphore * p_sem, int count);

int PICAdestroySemaphore(PICAsemaphore * p_sem);


#endif