/*****************************************************************************
 *
 * Copyright (C) 2002 Polytechnic University of Valencia.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Authors: Carlos Calafate, <calafate@disca.upv.es>
 *          Valentina Gaggero, <valentina.gaggero@libero.it>
 *
 *****************************************************************************/


#include "rtmanager.h"

int PICAgetAdapterIndex(char * device, unsigned int * index) {
	PIP_ADAPTER_INFO pAdapterInfo, pAdapt;
    DWORD AdapterInfoSize;
    DWORD Err;	

	if (strcmp(device,"lo") == 0) {
		*index = 1;
		return 1;
	}

    // Get sizing information about all adapters
    AdapterInfoSize = 0;
    if ((Err = GetAdaptersInfo(NULL, &AdapterInfoSize)) != 0) {
        if (Err != ERROR_BUFFER_OVERFLOW) {
            return 0;
        }
    }

    // Allocate memory from sizing information
    if ((pAdapterInfo = (PIP_ADAPTER_INFO) GlobalAlloc(GPTR,
		AdapterInfoSize)) == NULL) {        
        return 0;
    }
	
    // Get actual adapter information
    if ((Err = GetAdaptersInfo(pAdapterInfo, &AdapterInfoSize)) != 0) {        
        return 0;
    }

    pAdapt = pAdapterInfo;


	while (pAdapt != NULL) {		
		if (strcmp(pAdapt->AdapterName,device) == 0) {
			//found it
			*index = pAdapt->Index;
			GlobalFree(pAdapterInfo);
			return 1;
		}
        pAdapt = pAdapt->Next;				
    }
	
	//not found
	return 0;
}


int PICAgetAdapterName(char * device, unsigned int * index) {
	PIP_ADAPTER_INFO pAdapterInfo, pAdapt;
    DWORD AdapterInfoSize;
    DWORD Err;	

	if (*index ==1) {
		sprintf(device,"lo");
		return 1;
	}

    // Get sizing information about all adapters
    AdapterInfoSize = 0;
    if ((Err = GetAdaptersInfo(NULL, &AdapterInfoSize)) != 0) {
        if (Err != ERROR_BUFFER_OVERFLOW) {          
            return 0;
        }
    }

    // Allocate memory from sizing information
    if ((pAdapterInfo = (PIP_ADAPTER_INFO) GlobalAlloc(GPTR,
		AdapterInfoSize)) == NULL) {        
        return 0;
    }
	
    // Get actual adapter information
    if ((Err = GetAdaptersInfo(pAdapterInfo, &AdapterInfoSize)) != 0) {        
        return 0;
    }

    pAdapt = pAdapterInfo;

	//begin search
	while (pAdapt != NULL) {		
		if (*index == pAdapt->Index) { 
			//found it
			strcpy(device, pAdapt->AdapterName);
			GlobalFree(pAdapterInfo);
			return 1;
		}
        pAdapt = pAdapt->Next;				
    }

	//not found
	return 0;
}




int PICAaddRoute(UINT32 dest, UINT32 mask, UINT32 gateway,int metric, char * device) {
	
	MIB_IPFORWARDROW entry;
	unsigned int index = 0;	

	if (device == NULL) {
		P_ERROR("PICAaddRoute: device points to NULL",20101);
		return 0;
	}

	if (!PICAgetAdapterIndex(device,&index)) {
		P_ERROR("PICAaddRoute: Unable to get adapter's index",20102);
		return 0;
	}
	
	ZeroMemory(&entry, sizeof(MIB_IPFORWARDROW));

	entry.dwForwardDest = dest;
	entry.dwForwardMask = mask;
	entry.dwForwardNextHop = gateway;
	entry.dwForwardMetric1 = metric;
	entry.dwForwardIfIndex = index;
	entry.dwForwardProto = PROTO_IP_NETMGMT; 
	
	if(CreateIpForwardEntry(&entry) != NO_ERROR) {
		P_ERROR("PICAaddRoute: Error adding entry",20103);
		return 0;
	}
	return 1;
}


int PICAdelRoute(UINT32 dest,UINT32 mask, UINT32 gateway, char * device) {
	MIB_IPFORWARDROW entry;
	unsigned int index = 0;	

	if (device == NULL) {
		P_ERROR("PICAdelRoute: device points to NULL",20201);
		return 0;
	}

	if (!PICAgetAdapterIndex(device,&index)) {
		P_ERROR("PICAdelRoute: unable to get index of adapter",20202);
		return 0;
	}
	
	ZeroMemory(&entry, sizeof(MIB_IPFORWARDROW));

	entry.dwForwardDest = dest;
	entry.dwForwardMask = mask;
	entry.dwForwardNextHop = gateway;
//	entry.dwForwardMetric1 = metric;
	entry.dwForwardIfIndex = index;
	entry.dwForwardProto = PROTO_IP_NETMGMT;
	
	if(DeleteIpForwardEntry(&entry) != NO_ERROR) {
		P_ERROR("PICAdelRoute: Unable to remove entry from table",20203);	
		return 0;
	}

	return 1;
}

int PICAgetRoutingTable(RTInfo * rti) {
	DWORD Err, table_size = 0,i, init = 0;
	PMIB_IPFORWARDTABLE  pIptable;
	RTLines * newLine, * oldLine;	

#define INSUF_SIZE 122

	if (rti == NULL) {
		P_ERROR("PICAgetRoutingTable: rti points to NULL",20301);	
		return 0;	
	}
	

	if (GetIpForwardTable(NULL, &table_size,FALSE) != INSUF_SIZE) {
		P_ERROR("PICAgetRoutingTable: Unable to get forwarding table's size",20302);	
		return 0;
	}

    // Allocate memory from sizing information
    if ((pIptable = (PMIB_IPFORWARDTABLE) GlobalAlloc(GPTR, table_size)) == NULL) {        
		P_ERROR("PICAgetRoutingTable: Error while allocating memory",20303);			
        return 0;
    }
	
    // Get actual adapter information
    if ((Err = GetIpForwardTable(pIptable, &table_size,FALSE)) != 0) {        
		P_ERROR("PICAgetRoutingTable: Unable to get forwarding table",20304);	
		GlobalFree(pIptable);
        return 0;
    }

	rti->entry_count = pIptable->dwNumEntries;

	for (i=0; i<pIptable->dwNumEntries; i++) {

		if ((newLine = (RTLines *) malloc(sizeof(RTLines))) == NULL) {
			P_ERROR("PICAgetRoutingTable: Error while trying to allocate memory",20305);	
			GlobalFree(pIptable);
			return 0;
		}
 
		if ((newLine->device = (char *) malloc(128)) == NULL) {
			P_ERROR("PICAgetRoutingTable: Error while trying to allocate memory",20306);	
			GlobalFree(pIptable);
			return 0;
		}

		newLine->dest = (UINT32) pIptable->table[i].dwForwardDest;
		newLine->mask = pIptable->table[i].dwForwardMask;
		newLine->gw = pIptable->table[i].dwForwardNextHop;
		newLine->metric = pIptable->table[i].dwForwardMetric1;
			

		if (!PICAgetAdapterName(newLine->device,(unsigned int *) & pIptable->table[i].dwForwardIfIndex)) {
			P_ERROR("PICAgetRoutingTable: Unable to get adapter name from index",20307);	
			GlobalFree(pIptable);
			return 0;
		}

		newLine->next = NULL;
		if (!init) {
		  rti->entry_count = pIptable->dwNumEntries;
		  rti->lines = newLine; //saves first line address
		  init = 1;
		} else {
		  oldLine->next = newLine;
		}		
		oldLine = newLine;

  }

	if (GlobalFree(pIptable) != NULL) {
		P_ERROR("PICAgetRoutingTable: Error while trying to free memory",20308);				
		return 0;
	}

	return 1;
}
