#ifndef _DEVS_H
#define _DEVS_H

#include "PICAspec.h"

#include <Iphlpapi.h>
#include <stdio.h>
#include <string.h>

#define MAXDEVS 32
#define MAXDEVSIZE 128

typedef struct _DEVLIST {
  int num_devices;
  char dev_names[MAXDEVS][MAXDEVSIZE];
} DEVLIST;

typedef struct _DevAttrs {
  unsigned char ha[6];
  UINT32 ip_addr;
  UINT32 mask;
  long index;
} DevAttrs;

int PICAgetAvailableDevices(DEVLIST * devs);

int PICAgetDeviceAttrs(char * dev, DevAttrs * attrs);

#endif