
#include "devs.h"


int PICAgetAvailableDevices(DEVLIST * devs) {


    PIP_ADAPTER_INFO pAdapterInfo, pAdapt;
    DWORD AdapterInfoSize;
    DWORD Err;
	int num = 0;


	if (devs == NULL) {
		P_ERROR("PICAgetAvailableDevices: devs points to NULL", 10101);
        return 0;
	}

    // Get sizing information about all adapters
    AdapterInfoSize = 0;
    if ((Err = GetAdaptersInfo(NULL, &AdapterInfoSize)) != 0) {
        if (Err != ERROR_BUFFER_OVERFLOW) {
			P_ERROR("PICAgetAvailableDevices: Error getting size of structure", 10102);
            return 0;
        }
    } else {
		P_ERROR("PICAgetAvailableDevices: Unexpected result calling GetAdaptersInfo", 10103);
        return 0;
	}

    // Allocate memory from sizing information
    if ((pAdapterInfo = (PIP_ADAPTER_INFO) GlobalAlloc(GPTR, AdapterInfoSize)) == NULL) {        
        P_ERROR("PICAgetAvailableDevices: Unable to allocate memory", 10104);
		return 0;
    }
	
    // Get actual adapter information
    if ((Err = GetAdaptersInfo(pAdapterInfo, &AdapterInfoSize)) != 0) {        
		P_ERROR("PICAgetAvailableDevices: Unable to get the adapter's info", 10105);
		GlobalFree(pAdapterInfo);
        return 0;
    }

    pAdapt = pAdapterInfo;

	//save adapter's names
	while (pAdapt != NULL) {		
		sprintf(devs->dev_names[num],"%s",pAdapt->AdapterName);
        pAdapt = pAdapt->Next;		
		num++;
    }

	//save number of adapters
	devs->num_devices = num;
	
	//free alocated memory		
	if (GlobalFree(pAdapterInfo) != NULL) {
		P_ERROR("PICAgetAvailableDevices: Unable to free memory", 10106);
		return 0;
	}

	return 1;

}

int PICAgetDeviceAttrs(char * dev, DevAttrs * attrs) {
	

    PIP_ADAPTER_INFO pAdapterInfo, pAdapt;
    DWORD AdapterInfoSize;
    DWORD Err;
	BOOL end = FALSE;

	if (dev == NULL) {
		P_ERROR("PICAgetDeviceAttrs: dev points to NULL", 10201);
        return 0;
	}

	if (attrs == NULL) {
		P_ERROR("PICAgetDeviceAttrs: attrs points to NULL", 10202);
        return 0;
	}
	

	// Get sizing information about all adapters
    AdapterInfoSize = 0;
    if ((Err = GetAdaptersInfo(NULL, &AdapterInfoSize)) != 0) {
        if (Err != ERROR_BUFFER_OVERFLOW) {
			P_ERROR("PICAgetDeviceAttrs: Error getting size of structure", 10203);
            return 0;
        }
    } else {
		P_ERROR("PICAgetDeviceAttrs: Unexpected result calling GetAdaptersInfo", 10204);
        return 0;
	}

    // Allocate memory from sizing information
    if ((pAdapterInfo = (PIP_ADAPTER_INFO) GlobalAlloc(GPTR, AdapterInfoSize)) == NULL) {        
        P_ERROR("PICAgetDeviceAttrs: Unable to allocate memory", 10205);
		return 0;
    }
	
    // Get actual adapter information
    if ((Err = GetAdaptersInfo(pAdapterInfo, &AdapterInfoSize)) != 0) {        
		P_ERROR("PICAgetDeviceAttrs: Unable to get the adapter's info", 10206);
		GlobalFree(pAdapterInfo);
        return 0;
    }

    pAdapt = pAdapterInfo;

	//search for desired adapter
	while (pAdapt != NULL && !end) {				
		if (strcmp(pAdapt->AdapterName, dev) == 0) { 
			//found adapter
			memcpy(attrs->ha,pAdapt->Address,6);
			attrs->ip_addr = inet_addr(pAdapt->IpAddressList.IpAddress.String);	
			attrs->mask = inet_addr(pAdapt->IpAddressList.IpMask.String);
			attrs->index = pAdapt->Index;
			end = TRUE;
		}
        pAdapt = pAdapt->Next;				
    }

	if (end == FALSE) {
		P_ERROR("PICAgetDeviceAttrs: Device not found", 10207);
		GlobalFree(pAdapterInfo);
		return 0;
	}

	//free alocated memory	
	if (GlobalFree(pAdapterInfo) != NULL) {
		P_ERROR("PICAgetDeviceAttrs: Unable to free memory", 10208);
		return 0;
	}		

	return 1;
}
