/*****************************************************************************
 *
 * Copyright (C) 2002 Polytechnic University of Valencia.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Authors: Carlos Calafate, <calafate@disca.upv.es>
 *
 *****************************************************************************/


#include "packet.h"


int PICAopenDevice(char * device, PICA_IO_DEVICE * iodev, int timeout, int mode) {
unsigned short * wdevice;
int size;

	if (device == NULL) {
		P_ERROR("PICAopenDevice: device points to NULL", 40101);
		return 0;
	} else {
		size = sizeof(unsigned short) * strlen(device);
		wdevice= (unsigned short *) malloc(size);	
		MultiByteToWideChar(CP_ACP,MB_PRECOMPOSED,device,-1,wdevice,size);
	}

	if (iodev == NULL) {
		P_ERROR("PICAopenDevice: iodev points to NULL", 40102);
		free(wdevice);
		return 0;
	}

	
	if ((*iodev = PacketOpenAdapter(wdevice)) == NULL || ((*iodev)->hFile == INVALID_HANDLE_VALUE)) {
		P_ERROR("PICAopenDevice: Error while trying to open adapter", 40105);
		free(wdevice);
		return 0;
	} else {
		free(wdevice);
	}
//"	NDIS_PACKET_TYPE_ALL_LOCAL
	
/*	if(PacketSetHwFilter(*iodev,NDIS_PACKET_TYPE_PROMISCUOUS)==FALSE){			
	//if(PacketSetHwFilter(*iodev,NDIS_PACKET_TYPE_ALL_LOCAL)==FALSE){			
		P_ERROR("PICAopenDevice: Error setting promiscuous mode", 40106);		
		return 0;	
	}	*/


	if(mode==PROMISCUOUS)
	{
		if(PacketSetHwFilter(*iodev,NDIS_PACKET_TYPE_PROMISCUOUS)==FALSE){			
		P_ERROR("PICAopenDevice: Error setting promiscuous mode", 40105);
		return 0;	
		}
	}
	else 
	{
		if (mode==ALL_LOCAL)
		{
			if(PacketSetHwFilter(*iodev,NDIS_PACKET_TYPE_ALL_LOCAL)==FALSE)
			{			
				P_ERROR("PICAopenDevice: Error setting promiscuous mode", 40106);
				return 0;	
			}
		}
	
		else 
		{
			P_ERROR("PICAopenDevice: unknown mode to open device", 40107);	
			return 0;
		}

	}


	if(PacketSetBuff(*iodev,512*1024)==FALSE){				
		P_ERROR("PICAopenDevice: Unable to set kernel buffer size", 40107);		
		return 0;
	}

	/*if(PacketSetReadTimeout (*iodev, 0) == FALSE) { //wait forever
		P_ERROR("PICAopenDevice: Unable to set kernel buffer size", 40108);		
		return 0;
	}*/

	if(PacketSetNumWrites (*iodev, 1) == FALSE) {
		P_ERROR("PICAopenDevice: Unable to set number of bytes read before returning", 40108);		
		return 0;
	}	

	if (!PacketSetMinToCopy(*iodev,1)) {
		P_ERROR("PICAopenDevice: Error while setting minimum number of bytes to copy", 40109);	
		return 0;
	}

	if(timeout < -1)
	{
		P_ERROR("PICAopenDevice: timeout values is lesser than -1", 40110);
		return 0;
	}

	if(!PacketSetReadTimeout(*iodev, timeout))
	{
		P_ERROR("PICAopenDevice: Error while setting timeout", 40111);
		return 0;
	}


	return 1;
}


int PICAframe(int mode, PICA_IO_DEVICE iodev, void * packet, int packetsize, int * datasize) {
		
	PACKET pkt, * lpPacket;
	char * aux;	
	unsigned short * buffer;
	int retval = 1;
	u_int off=0;
	struct bpf_hdr *hdr;


	if (packet == NULL) {
		P_ERROR("PICAframe: packet points to NULL", 40201);
		return 0;
	}

	if (datasize == NULL) {
		P_ERROR("PICAframe: datasize points to NULL", 40202);
		return 0;
	}	

	if(iodev == NULL)
	{
		P_ERROR("PICAframe: datasize points to NULL", 40203);
		return 0;
	}


	if (mode == PICA_SEND) {			
		
		/*ZeroMemory( &pkt, sizeof( pkt ) );
		PacketInitPacket(&pkt, buffer, packetsize);*/
		pkt.Buffer = packet;
		pkt.Length = packetsize;
		pkt.ulBytesReceived = packetsize;
	
		if (!PacketSendPacket(iodev, &pkt, TRUE)) {
			P_ERROR("PICAframe: error sending packet", 40204);
			return 0;
		}
	
	} else if (mode == PICA_RECEIVE) {
		
		if ((buffer = (unsigned short *) malloc(2048)) == NULL) {
			P_ERROR("PICAframe: error allocating memory", 40205);
			return 0;
		}
		if((lpPacket = PacketAllocatePacket())==NULL){
			P_ERROR("PICAframe: error allocating packet memory", 40206);
			return 0;
		} 
	
	
		PacketInitPacket(lpPacket, buffer, 2048);
	
		do {		
			ZeroMemory( &pkt, sizeof( pkt ) );
			PacketInitPacket(&pkt, buffer, 2047);

		
			
			if (!PacketReceivePacket(iodev, lpPacket,TRUE)) {
				P_ERROR("PICAframe: error receiving packet", 40207);
				return 0;
			} else {
				if (lpPacket->ulBytesReceived > 0) {
					aux = (char *) lpPacket->Buffer;
			
					hdr=(struct bpf_hdr *)(buffer);
			

					if (packetsize < hdr->bh_datalen) {
						P_ERROR("PICAframe: packetsize is not big enough to contain packet", 40208);
						return 0;
					} else {
						if ((*datasize = hdr->bh_datalen) > 19) {				
							aux = &aux[hdr->bh_hdrlen];					
							memcpy((char *) packet,(char *) aux,*datasize);
						}
					}
				}
				
			}
		} while (lpPacket->ulBytesReceived < 1 || hdr->bh_datalen < 20);


	/*	if (!PacketReceivePacket(iodev, lpPacket,TRUE))
		{
			P_ERROR("PICAframe: error receiving packet", 40207);
			return 0;
		} 
		else
		{
		
			aux = (char *) lpPacket->Buffer;
	
			hdr=(struct bpf_hdr *)(buffer);
	
			if (packetsize < hdr->bh_datalen)
			{
				P_ERROR("PICAframe: packetsize is not big enough to contain packet", 40208);
				return 0;
			}
			else
			{
				*datasize = hdr->bh_datalen;

				aux = &aux[hdr->bh_hdrlen];
		
				memcpy((char *) packet,(char *) aux,*datasize);
				
			}
		}
		*/
		  
		PacketFreePacket(lpPacket);
		free(buffer);

	} else {
		P_ERROR("PICAframe: unknown user option", 40209);		
		return 0;
	}

	return 1;
}



int PICAcloseDevice(PICA_IO_DEVICE iodev) {
	
	if (iodev == NULL) {
		P_ERROR("PICAcloseDevice: iodev is NULL", 40301);		
		return 0;
	}
	
	PacketCloseAdapter(iodev);

	return 1;
}


int PICAcreatePacket(char *addr, unsigned char *data, int datasize, unsigned char * packet, int * packetsize)
{
	int i=0, j=0,k, size, h;
	unsigned char addr_aux[2];
	unsigned cifra1, cifra2, finale;
	char data_aux [46];

	if(addr==NULL)
	{
		P_ERROR("PICAcreatepacket: parameter addr is null",40401);
		return 0;
	}
	
	if(data==NULL)
	{
		P_ERROR("PICAcreatepacket: parameter data is null",40401);
		return 0;
	}

	if(packet==NULL)
	{
		P_ERROR("PICAcreatepacket: parameter packet is null",40401);
		return 0;
	}

	if(packetsize==NULL)
	{
		P_ERROR("PICAcreatepacket: parameter packetsize is null",40401);
		return 0;
	}

	if(datasize < 46)
	{
		P_ERROR("PICAcreatepacket: datasize is too small",40401);
		return 0;
	}

	
	

//check address
	if(addr[2]==':' && addr[5]==':' && addr[8]==':' && addr[11]==':' && addr[14]==':')
	{
	ZeroMemory(&addr_aux[0],2);
	while(i<17)
	{
		for(k=i; k<=i+1;k++)
		{

			if(addr[k]>= '0' && addr[k]<= '9')
			{
				addr_aux[k-i]=addr[k]-'0';

			}
			else if (addr[k]>= 'A' && addr[k]<= 'F')
			{
				addr_aux[k-i]=addr[k]-'A' + 10;
			}
			else if (addr[k]>= 'a' && addr[k]<= 'f')
			{
				addr_aux[k-i]=addr[k]-'a'+10;
			}
			else 
			{
				P_ERROR("PICAcreatepacket: bad format address number 0-9 digit a-f or A-F",40401);
				return 0;
			}
		}//fine for su k
		printf("\n\n");
		packet[j]= (addr_aux[0] << 4) | addr_aux[1] ;
		//printf("buf %d: %x\n", j, buf[j]);
		i+=3;
		j++;
	}
	}
	else 
	{
		P_ERROR("PICAcreatepacket:bad format address!!! use ':' \n", 40402);
		return 0;
	}

//dal 6 al 13 non si tocca
//fare la copia dei dati da data a buf[14]
//type or length
packet[12]=data[0];
packet[13]=data[1];
//controllare che la dim dei dat sia > 46 llora usare quella li se no usare 46 ok

	memcpy(&packet[14], &data[2], datasize);
	*packetsize=datasize+14;

	printf("create packet: DATI CONTENUTI NEL PACHETTO!!\n");
	printf("destination: ");
	for(i=0; i<6;i++)
	{
		printf ("%x ", packet[i]);
	}
	printf("\n source: ");
	for(i=6; i<12;i++)
	{
		printf ("%x ", packet[i]);
	}
	printf("\n lenth: ");
	for(i=12; i<14;i++)
	{
		printf ("%x ", packet[i]);
	}
	printf("\n data: ");
	for(i=14; i<datasize+14;i++)
	{
		printf ("%x ", packet[i]);
	}
	//buf=packet;
	
	return 1;
}
/*
int PICAcreatePacket(char *addr, char *data, int datasize, unsigned char * packet, int * packetsize)
{
	int i=0, j=0,k, size;
	unsigned char addr_aux[2];
	unsigned cifra1, cifra2, finale;
	//unsigned char buf [1514]; //1500 (dati) + 6 destinatio +6 sourse +2 lenght
	unsigned char * buf;

	packet=(unsigned char *) GlobalAlloc(GMEM_FIXED, 1514*sizeof(unsigned char));
	

//check address
	if(addr[2]==':' && addr[5]==':' && addr[8]==':' && addr[11]==':' && addr[14]==':')
	{
	//ZeroMemory(&buf[0],14);
	ZeroMemory(&addr_aux[0],2);
	while(i<17)
	{
		for(k=i; k<=i+1;k++)
		{
			//printf("--------k=%d\n", k);
			if(addr[k]>= '0' && addr[k]<= '9')
			{
				addr_aux[k-i]=addr[k]-'0';
				//printf("e`una cifra!!\n");
				//printf("valore exa: %x\n", addr_aux[k-i]);
			}
			else if (addr[k]>= 'A' && addr[k]<= 'F')
			{
				addr_aux[k-i]=addr[k]-'A' + 10;
				//printf("e`una lettera maiuscola!!\n");
				//printf("valore exa: %x\n", addr_aux[k-i]);
			}
			else if (addr[k]>= 'a' && addr[k]<= 'f')
			{
				addr_aux[k-i]=addr[k]-'a'+10;
				//printf("e`una lettera minuscola!!\n");
				printf("valore exa: %x\n", addr_aux[k-i]);
			}
			else 
			{
				P_ERROR("PICAcreatepacket: bad format address number 0-9 digit a-f or A-F",40401);
				//printf("error address formed!!! number 0-9 digit a-f or A-F \n", ); 
				return 0;
			}
		}//fine for su k
		printf("\n\n");
		packet[j]= (addr_aux[0] << 4) | addr_aux[1] ;
		printf("buf %d: %x\n", j, buf[j]);
		i+=3;
		j++;
	}
	}
	else 
	{
		P_ERROR("PICAcreatepacket:bad format address!!! use ':' \n", 40402);
		return 0;
	}

//dal 6 al 13 non si tocca
//fare la copia dei dati da data a buf[14]
//controllare che la dim dei dat sia > 46 llora usare quella li se no usare 46


	memcpy(&packet[14], data, datasize);
	*packetsize=datasize+14;

	printf("create packet: DATI CONTENUTI NEL PACHETTO!!\n");
	printf("destination: ");
	for(i=0; i<6;i++)
	{
		printf ("%x ", packet[i]);
	}
	printf("\n source: ");
	for(i=6; i<12;i++)
	{
		printf ("%x ", packet[i]);
	}
	printf("\n lenth: ");
	for(i=12; i<14;i++)
	{
		printf ("%x ", packet[i]);
	}
	printf("\n data: ");
	for(i=14; i<datasize+14;i++)
	{
		printf ("%x ", packet[i]);
	}
	//buf=packet;
	return 1;
}
*/