/*****************************************************************************
 *
 * Copyright (C) 2002 Polytechnic University of Valencia.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Authors: Carlos Calafate, <calafate@disca.upv.es>
 *
 *****************************************************************************/

// PICA_lib_testDlg.cpp : implementation file
//

#include "stdafx.h"
#include "PICA_lib_test.h"
#include "PICA_lib_testDlg.h"
#include "PICA/pica.h"
#include <stdio.h>

#include <Iprtrmib.h> //quitar
#include <Iphlpapi.h> //quitar

#include <winsock.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

static bool run=true;
PICAmutex mymut;
PICAsemaphore mysem;

/////////////////////////////////////////////////////////////////////////////
// CPICA_lib_testDlg dialog

CPICA_lib_testDlg::CPICA_lib_testDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CPICA_lib_testDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CPICA_lib_testDlg)
	m_text = _T("");
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);

}

void CPICA_lib_testDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPICA_lib_testDlg)
	DDX_Text(pDX, IDC_TEXT, m_text);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CPICA_lib_testDlg, CDialog)
	//{{AFX_MSG_MAP(CPICA_lib_testDlg)
	ON_BN_CLICKED(IDC_TEST, OnTest)
	ON_BN_CLICKED(IDC_BUTTON1, OnPipe)
	ON_BN_CLICKED(IDC_BUTTON2, OnForwarding)
	ON_BN_CLICKED(IDC_BUTTON3, OnRTable)
	ON_BN_CLICKED(IDC_BUTTON4, OnDevs)
	ON_BN_CLICKED(IDC_BUTTON5, OnLog)
	ON_BN_CLICKED(IDC_BUTTON6, OnSocket)
	ON_BN_CLICKED(IDC_BUTTON7, OnPacket)
	ON_BN_CLICKED(IDC_BUTTON8, OnThread)
	ON_BN_CLICKED(IDC_BUTTON9, OnTimerT)
	ON_BN_CLICKED(IDC_BUTTON10, OnthreadMutexSyncr)
	ON_BN_CLICKED(IDC_CLOSE, OnClose)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPICA_lib_testDlg message handlers

BOOL CPICA_lib_testDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	int err;
	char buf [100];

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	CenterWindow(GetDesktopWindow());	// center to the hpc screen

	// TODO: Add extra initialization here
if (!PICAstartup())
{
	PICAgetLastError(buf, &err);
	sprintf(text, "Inizilizing error %d : %s", err, buf);
	printf(text);
	return FALSE;

}
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}


void CPICA_lib_testDlg::printf(char * data) {
	unsigned short wides[1024];		

	MultiByteToWideChar(CP_ACP,MB_PRECOMPOSED,data,-1,wides,1024);

	m_text.Format(L"%s%s\r\n",m_text,wides);
	UpdateData(FALSE);


}




void CPICA_lib_testDlg::OnTest() 
{
	// TODO: Add your control notification handler code here

	int adm; //1		
PICAsocket mysock;

  m_text = L"";	

  printf("Inicio");



  if (!PICAisAdministrator(&adm)) printf("Error getting ADM. data");
  else {
	  sprintf(text,"Success getting ADM. data: user is %s",adm>0?"Administrator":"not Administrator");
	  printf(text);
  }

//blocking socket creation
	  if (!PICAcreateSocket(&mysock,PF_INET, SOCK_DGRAM, 0, 2)) printf("Error creating socket");
	  else printf("socket created");
	  if (!PICAcloseSocket(mysock)) printf("Error closing socket");
	  else printf("Socket closed");
	

  
  
}

void CPICA_lib_testDlg::OnPipe() 
{
	PICApipe inpipe, outpipe;
	unsigned char pdata[] = "Os meus dados", buf[512];
	int len, ret;

  PICAbuffer * pbuf;
  PICApacket * packets;
  char  buf1[] = "111111111111111";
  char  buf2[] = "22222222222222222";
  char  buf3[] = "3333333333333";
  int size, i, avail_packets;

	m_text = L"";	

     if (!PICAmakePipe(&inpipe, &outpipe)) printf("Error making pipe");
     else printf("Success opening pipes");
 
	 len = 14;
     if (!PICAsendToPipe(outpipe, pdata, len+100, &ret)) printf("Error sending");        
	 else
	 {
		 sprintf(text, "Sent %d bytes", ret);
		 printf(text);
	 }

     if (!PICAgetFromPipe(inpipe, buf, 512, &ret)) printf("Error receiving");
     else {
            buf[ret] = '\0';
            sprintf(text,"received %d bytes: %s",ret,buf);
			printf(text);
     }

     if (!PICAclosePipe(inpipe)) printf("Error closing pipe");
     else printf("Closed pipe");
     if (!PICAclosePipe(outpipe)) printf("Error closing pipe");
     else printf("Closed pipe");		


	 //////////////////
	 printf("");

	 if (!PICAinitBuffer(&pbuf, 3)) printf("Error starting buffer");
	 else printf("Buffer initiated");	

  size = strlen(buf1);
  
  if (!PICAaddToBuffer(pbuf,0, buf1, size+100)) printf("Error adding to buffer");
  else printf("Added data to buffer");

 if (!PICAaddToBuffer(pbuf,0, buf2, size)) printf("Error adding to buffer");
  else printf("Added data to buffer");

 if (!PICAaddToBuffer(pbuf,0, buf3, size)) printf("Error adding to buffer");
  else printf("Added data to buffer");


/*
 for (i=0;i<3;i++) {
  
   sprintf(text,"Getting row %d",i);
   printf(text);

   if (!PICAgetFromBuffer(pbuf, i, 3, &packets,&avail_packets)) printf("Error getting from buffer\n");
   else {
	   sprintf(text,"Got data from buffer: %d packets",avail_packets);
	   printf(text);
   }

   if (packets == NULL) printf ("packets is null");

   while (packets != NULL) {
//     ((char *)packets->data)[packets->packet_size - 1] = '\0';
     sprintf(text, "Data: %s",(char *) packets->data);
	 printf(text);
     packets = packets->next;
   }
   
 }*/

  for (i=0;i<3;i++) {
  
   sprintf(text, "\nTring to get 3 packet from queue %d\n",i);
   printf(text);

   if (!PICAgetFromBuffer(pbuf, i, 3, &packets,&avail_packets)) printf("Error getting from buffer\n");
   else
   {
	   sprintf(text,"Got data from buffer: avail_packets: %d\n",avail_packets);
	   printf(text);
   }
   if(avail_packets != 0)
   {
	   if (packets == NULL) printf ("packets is null\n");

	   while (packets != NULL) {
		 sprintf(text, "packet size: %d  ", packets->packet_size);
		printf(text);
		 sprintf(text, "Data: %s\n",(char *) packets->data);
		 printf(text);
		 packets = packets->next;
	   }
	  
	   sprintf(text, "trying to get from queue %d an other time\n", i);
	   printf(text);
	    i--;	
   }   
 }


 if (!PICAkillBuffer(pbuf)) printf("Error killing buffer");
  else printf("Buffer killed");


}

void CPICA_lib_testDlg::OnForwarding() 
{
  int tf;
  int ttl;
  char msg[128];
  int err, e;


	  m_text = L"";	


	//if (SetIpTTL(65) != NO_ERROR) printf("Error setting TTL");
	//else printf("TTL set");

	// using windows primitive
/*	 printf("using windows primitive!!");


	if (GetIpStatistics(&lstats) != NO_ERROR) {
		printf("Error getting forwarding state");
		return;
	} else printf("Got statistics");

	sprintf(text,"TTL is %d and forwarding is %d",lstats.dwDefaultTTL, lstats.dwForwarding);
	printf(text);

	
	lstats.dwForwarding = MIB_IP_FORWARDING; //start forwarding
	//lstats.dwForwarding = MIB_IP_NOT_FORWARDING; //stop forwarding	

	/*if ((ret = SetIpStatistics(&lstats)) != NO_ERROR) {
	    printf("Error setting forwarding state");		
		FormatMessage(FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM | FORMAT_MESSAGE_IGNORE_INSERTS, NULL,  GetLastError(), 0, (LPTSTR) &lpMsgBuf, 0, NULL);

	MessageBox((LPCTSTR)lpMsgBuf,L"Error",MB_OK);
		
	// Free the buffer.
	LocalFree( lpMsgBuf );

	} else printf("Forwarding set");
	
	return;//



	//lo riscrivo:
	if ((ret = SetIpStatistics(&lstats)) != NO_ERROR)
	{
	    printf("Error setting forwarding state");		
		FormatMessage(FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM | FORMAT_MESSAGE_IGNORE_INSERTS, NULL,  GetLastError(), 0, (LPTSTR) &lpMsgBuf, 0, NULL);

	MessageBox((LPCTSTR)lpMsgBuf,L"Error",MB_OK);
		
	// Free the buffer.
	LocalFree( lpMsgBuf );
	return;

	} else printf("Forwarding set");
	
*/
	
	//using PICA
	printf("using PICA!!");
	e=PICAdefaultTTL(TTL_GET, &ttl);
	if (e!=1)
	{
		PICAgetLastError(msg, &err);
		sprintf(text,"TTL: %s num err:%d",msg, e);  		
		printf(text);
	}
	else
	{
		sprintf(text,"TTL is %d",ttl);
		printf(text);			
	}

	ttl++;

	printf("add 1 to preview TTL value");
e=PICAdefaultTTL(TTL_SET, &ttl);
	if (e!=1) 
	{
		//printf("PICAdefaultTTL Error setting TTL");
		PICAgetLastError(msg, &err);
		sprintf(text,"TTL: %s num err:%d",msg, err);  		
		printf(text);
	}

	else
	{
		sprintf(text,"TTL set to %d",ttl);
		printf(text);			
	}

	if (!PICAdefaultTTL(TTL_GET, &ttl)) printf("Error getting TTL");
	else
	{
		sprintf(text,"TTL is %d",ttl);
		printf(text);			
	}
 
/*	FormatMessage(FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM | FORMAT_MESSAGE_IGNORE_INSERTS, NULL,  GetLastError(), 0, (LPTSTR) &lpMsgBuf, 0, NULL);

	MessageBox((LPCTSTR)lpMsgBuf,L"Error",MB_OK);
		
	// Free the buffer.
	LocalFree( lpMsgBuf );

*/
//	return;




	if (!PICAisForwarding(&tf)) printf("PICAisForwarding: Error getting forwarding state");
	else
	{
		sprintf(text,"Forwarding is %s",tf>0?"ON":"OFF");
		printf(text);		
	}
  
if(tf>0)//if forwarding is on
{

  if (!PICAsetForwarding(FWD_OFF)) printf("PICAisForwarding:Error stopping forwarding");
  else
  {
	if (!PICAisForwarding(&tf)) printf("PICAisForwarding:Error getting forwarding state");
	else
	{
		sprintf(text,"Forwarding is %s",tf>0?"ON":"OFF");
		printf(text);		
	}
  }
}
else
{
  if (!PICAsetForwarding(FWD_ON)) printf("PICAisForwarding:Error starting forwarding");
  else
  {
	if (!PICAisForwarding(&tf)) printf("PICAisForwarding: Error getting forwarding state");
	else
	{
		sprintf(text,"Forwarding is %s",tf>0?"ON":"OFF");
		printf(text);		
	}
  }
}
	
}

void CPICA_lib_testDlg::OnRTable() 
{
	char buf[128];
	int adm;
	 RTInfo rt;
	RTLines * line;
	struct in_addr dest,mask,gw;
	char s_dest[16], s_mask[16], s_gw[16];


	 m_text = L"";	


  if (PICAaddRoute(inet_addr("192.168.0.13"),inet_addr("255.255.255.255"),inet_addr("192.168.0.1"),1,"EC2NDS1")) printf("Sucess adding route");
  else {
	  PICAgetLastError(buf,&adm);
	    sprintf(text,"Error adding route: %s",buf);  		
		printf(text);			 
  }

  if (!PICAgetRoutingTable(& rt)) {
		PICAgetLastError(buf,&adm);
	  sprintf(text,"Error reading RT: %s",buf);
	  printf(text);		
  }
  else {
	printf("Success reading RT");
  
	sprintf(text,"Linhas: %d", rt.entry_count);
	printf(text);		
	sprintf(text,"\tdest\t\tmask\t\tgw\tmetric\tif"); 
	printf(text);		
	line = rt.lines;
    while (line != NULL) {
		dest.s_addr = line->dest;
		strcpy(s_dest,inet_ntoa(dest));
		mask.s_addr = line->mask;
		strcpy(s_mask,inet_ntoa(mask));
		gw.s_addr = line->gw;
		strcpy(s_gw,inet_ntoa(gw));
		sprintf(text,"%14s\t%14s\t%14s\t%3d\t%4s",s_dest,s_mask,s_gw,line->metric,line->device);
		printf(text);		
		line = line->next;
	  }	  
  }
	
  printf("");
  if (PICAdelRoute(inet_addr("192.168.0.13"),inet_addr("255.255.255.255"),inet_addr("192.168.0.1"),"EC2NDS1")) printf("Success removing route");
  else printf("Error removing route");

}

void CPICA_lib_testDlg::OnDevs() 
{
	DEVLIST devs;
	int i;
	DevAttrs attrs;
	struct in_addr ip;

	m_text = L"";	

	if (!PICAgetAvailableDevices(&devs)) printf("Error getting devices");
	else {
		sprintf(text, "Devices:%d");
		printf(text);
		for (i=0;i<devs.num_devices;i++) {
			sprintf(text,"Device: %s", devs.dev_names[i]);
			printf(text);
			PICAgetDeviceAttrs(devs.dev_names[i], &attrs);
			ip.s_addr = attrs.ip_addr;
			sprintf(text,"IP: %s MAC: %2.2X:%2.2X:%2.2X:%2.2X:%2.2X:%2.2X", inet_ntoa(ip),attrs.ha[0],attrs.ha[1],attrs.ha[2],attrs.ha[3],attrs.ha[4],attrs.ha[5]);
			printf(text);
		}
	}
}

void CPICA_lib_testDlg::OnLog() 
{
	FDesc myfile;
	char buf[10], dados[] = "222";	
	int size;	


	 m_text = L"";	

	if (!PICAopenFile(&myfile,"\\mig.txt",WRITEF, APPEND)) printf("Error opening file");
	else {
		if (!PICAwriteToFile(myfile, dados, strlen(dados))) printf("Error wrinting\n");
		else printf("Data written");
		if (!PICAcloseFile(myfile)) printf("Error closing file");
	}


	if (!PICAopenFile(&myfile,"\\mig.txt",READF, 0)) printf("Error opening file");
	else {
		if (!PICAreadFile(myfile, buf, 10, &size)) {
			PICAgetLastError(buf,&size);
			sprintf(text,"Error reading file (%d): %s",size, buf);  		
			printf(text);			 
//			printf("Error reading\n");
		}
		else {			
			sprintf(text,"Data read: %d bytes",size);
			printf(text);		
			if (size > 0) {				
				buf[size] = '\0';
				buf[size+1] = '\0';
				sprintf(text,"%s", buf);
				printf(text);			
			}
		}
		if (!PICAcloseFile(myfile)) printf("Error closing file");
	}


/*
	CloseHandle(myfile);

		FormatMessage(FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM | FORMAT_MESSAGE_IGNORE_INSERTS, NULL,  GetLastError(), 0, (LPTSTR) &lpMsgBuf, 0, NULL);

	MessageBox((LPCTSTR)lpMsgBuf,L"Error",MB_OK);
		
	// Free the buffer.
	LocalFree( lpMsgBuf );
*/

}
//this select test function even if it has a differnet name
void CPICA_lib_testDlg::OnSocket() 
{
	
	test_select();
}

void CPICA_lib_testDlg::OnPacket() 
{
if(!PICAcleanup()) printf("error in cleaning pica");
else printf("pica cleaned!!");
//-------------- CODIVE CECCHIO -----------------------
	//TCHAR dev[] = L"WLLUC461";
/*	char dev[] = "WLLUC461";
	PICA_IO_DEVICE iodev;
	char tmpstr[100] = "";
	char errbuf[100];
	int size=-1115, i, j, k, code;
	char buf[100];
	m_text = L"";

	//buf= (char*)malloc (100*sizeof(char)); //CON MALLOC NON FUNZIONA
	//buf= (char *)GlobalAlloc(GMEM_FIXED, 200*sizeof(char));
	//buf="cacchio qui ci vorrebbe ilmsg di errore!!!";

	if (!PICAopenDevice(dev, &iodev)) {
   	    PICAgetLastError(buf,&size);
	    sprintf(text,"Error %d opening device: %s",size, buf);  		
		printf(text);			 
		//printf("Error opening device");
	}
	else {
		printf("Success opening device");

	
	for (k=0;k<3;k++) {

		buf[0] = 0x00;
		buf[1] = 0x20;
		buf[2] = 0xFF;
		buf[3] = 0xFF;
		buf[4] = 0x42;
		buf[5] = 0x77;

		buf[6] = 0x00;
		buf[7] = 0x02;
		buf[8] = 0x2D;
		buf[9] = 0x08;
		buf[10] = 0x42;
		buf[11] = 0x88;
		

	/*	for (j=0;j<3;j++) {
			size = 128;
			if (!PICAframe(PICA_SEND, iodev, buf, 128, &size)) {
				PICAgetLastError(errbuf,&code);
				sprintf(text,"Error sending data: %s",errbuf);  		
				printf(text);			 
				//printf("Error sending packet");
			} else printf("Packet sent");
		} */
	/*
		//quitar
		if (!PICAcloseDevice(iodev)) printf("Error closing device");
		else printf("Success closing device");

		return;
		
		//ZeroMemory(buf,2048);
	*-/
		for (j=0;j<1;j++) {
			
			if (!PICAframe(PICA_RECEIVE, iodev, buf, 4096, &size)) {
				PICAgetLastError(errbuf,&code);
				sprintf(text,"Error receiving data: %s",errbuf);  		
				printf(text);
				//printf("Error receiving packet");
		}
			else {
				sprintf(text,"Packet received with size: %d",size);
				printf(text);
				sprintf(text,"");
				for (i=0;i<size;i++) {			
					sprintf(tmpstr, "%x ", (unsigned char) buf[i]);
					strcat(text, tmpstr);						
				}	
				printf(text);
			}

		}

	}//fim for k

		if (!PICAcloseDevice(iodev)) printf("Error closing device");
		else printf("Success closing device");
	
	}*/
}


BOOL CPICA_lib_testDlg::DestroyWindow() 
{
	// TODO: Add your specialized code here and/or call the base class
	
	PICAcleanup();

	return CDialog::DestroyWindow();
}


void CPICA_lib_testDlg::test_select(void) {

	HANDLE myevent, myevent2;
	PICAsocket mysock;
	PICAdescList * dl;
	PICAselResult res;
	PICApipe in, out;
	char buf[100] = "Data sent to pipe";
	int code, written;

	//nuevo

/*
	PICAdescList * socks, * runner;
	int sock_cnt, sock_num, end;
	char val[8];
	SOCKET * curr_sock;

	struct timeval to, * sel_time;
	fd_set rread;
	int socketopen=1;
	int sr, timeout;



	if (!PICAmakePipe(&in, &out)) printf("Error creating pipe\n");
	
	if (!PICAcreateSocket(&mysock,PF_INET, SOCK_DGRAM, 0)) printf("Error creating socket\n");
	else printf("socket created");
  
  if (!PICAsendToPipe(out, buf, strlen(buf), &written)) printf("Error writing to pipe\n");

	printf("Starting select");

	dl = NULL;
		
	if (!PICAaddDesc(&dl, PICA_PIPE_TYPE,PICA_W_READ, &in)) printf("Error adding descriptor\n");
	if (!PICAaddDesc(&dl, PICA_SOCKET_TYPE,PICA_W_READ, &mysock)) printf("Error adding descriptor\n");
//	if (!PICAaddDesc(&dl, PICA_SOCKET_TYPE,PICA_W_READ, &mysock)) printf("Error adding descriptor\n");

	socks = (PICAdescList *) dl;

	runner = socks;
	sock_cnt = 0;
	FD_ZERO(&rread);

	while (runner != NULL) {
		sock_cnt++;	
		curr_sock = (SOCKET *) (runner->desc);
		FD_SET(*curr_sock,&rread);
		runner = runner->next;
	}		

	
	timeout = 500;

	sel_time = NULL;
	// sel_time = &to;
    
    memset((char *)&to,0,sizeof(to)); // clear the timeval struct
    to.tv_sec= (long) timeout / 1000;	
	to.tv_usec = (long) (timeout - to.tv_sec*1000)/1000;
    
    // do the select.  
    // select returns > 0 if there is a read event on the socket 
    // e.g. data waiting to be read


    if ((sr=select(0, &rread, (fd_set *)0, (fd_set *)0, sel_time)) == SOCKET_ERROR) {
		
	//	printf("Error %d in real select\n", WSAGetLastError()); 
	//	printf("Codes:\nWSAENOTSOCK = %d\nWSAEFAULT = %d\n",WSAENOTSOCK,WSAEFAULT);
		//sprintf(val,"%d",-1);
		//WriteFile(w_Pipe,val,8,(unsigned long *) &written,NULL);
	printf("Error in select");
	} else if (sr == 0) {
		//Timeout in select. Do nothing
		printf("Timeout in select");
		
	} else {
		
		printf("Socket supposed found!");
		end = 0;
		sock_num = 0;
		runner = socks;
		while (runner != NULL && !end) {
			printf("In the cicle");
			curr_sock = (SOCKET *) runner->desc;
			if (FD_ISSET(*curr_sock,&rread))
			  {
				//sprintf(val,"%d",sock_num);
				//WriteFile(w_Pipe,val,8,(unsigned long *) &written,NULL);
				printf("Found socket active");
				end = 1;
			  }
			sock_num++;
			runner = runner->next;
		}

	}

	printf("fin");

return;

*/
	//fin

	
	printf("\n------------------ Select test -----------------\n");
	
	myevent = CreateEvent(NULL,FALSE,FALSE,NULL);
	myevent2 = CreateEvent(NULL,FALSE,FALSE,NULL);
	SetEvent(myevent2);

	if (!PICAmakePipe(&in, &out)) printf("Error creating pipe\n");




if (!PICAcreateSocket(&mysock,PF_INET, SOCK_DGRAM, 0, 2)) printf("Error creating socket\n");
  else printf("socket created");
  


	printf("Starting select");

	dl = NULL;
		
	if (!PICAaddDesc(&dl, PICA_PIPE_TYPE, &in)) printf("Error adding descriptor\n");
	if (!PICAaddDesc(&dl, PICA_SOCKET_TYPE, &mysock)) printf("Error adding descriptor\n");
//	if (!PICAaddDesc(&dl, PICA_SOCKET_TYPE, &mysock)) printf("Error adding descriptor\n");
	if (!PICAaddDesc(&dl, PICA_OTHER_TYPE, &myevent)) printf("Error adding descriptor\n");
	if (!PICAaddDesc(&dl, PICA_OTHER_TYPE, &myevent2)) printf("Error adding descriptor\n");


//	printf("main: dl is %x\n",dl);
	

	if (! PICAselect(20, dl,  &res))
	{
		PICAgetLastError(buf,&code);		
		sprintf(text,"Error %d in PICAselect: %s\n",code, buf);
		printf(text);
	}
	else {

			printf("Success in select\n");
			if (res.type == PICA_TIMEOUT_TYPE) printf("Selection result is timeout\n");
			else if (res.type == PICA_PIPE_TYPE)
			{
				printf("Selection result of pipe type\n");
				sprintf(buf,"");
				PICAgetFromPipe(in, buf, 100, &written);
				buf[written] = '\0';
				sprintf(text,"Pipe activated. Data: %s\n",buf);
				printf(text);
			}
			else 
			{
				sprintf(text,"Results: type = %d desc= %x. event desc= %x\n",res.type,res.desc, &myevent2);
				printf(text);
			}
		
		}   	


	

	

  if (!PICAsendToPipe(out, buf, strlen(buf), &written)) printf("Error writing to pipe\n");
 SetEvent(myevent);


	if (!PICAselect(500, dl,  &res)) {
		PICAgetLastError(buf,&code);
		sprintf(text,"Error in PICAselect: %s\n", buf);
		printf(text);
	}
	else {
		printf("Success in select\n");
		if (res.type == PICA_TIMEOUT_TYPE) printf("Selection result is timeout\n");
		else if (res.type == PICA_PIPE_TYPE) {
			sprintf(buf,"");
			PICAgetFromPipe(in, buf, 100, &written);
			buf[written] = '\0';
			sprintf(text,"Pipe activated. Data: %s\n",buf);
			printf(text);
		}
		else {
			sprintf(text,"Results: type = %d desc= %x. event desc= %x\n",res.type,res.desc, &myevent);
			printf(text);
		}
	}


}



DWORD WINAPI thrfunc(void * data) {
	CString * texto;

	texto = (CString *) data;
	*texto += L"sono il thread: prima dl while!!\r\n";

	while (1) {
		*texto += L"sono il thread: dentro dl while!!\r\n";
		*texto += L" dormo\r\n";
		Sleep(1000);
		*texto += L"sveglio\r\n";
	}
	*texto += L"sono il thread: dopo dl while!!\r\n";
	return 0;
}


DWORD WINAPI thrfunc2(void * data) {
	CString * texto;

	texto = (CString *) data;
	*texto += L"sono il thread: prima dl while!!\r\n";


   // printf("Thread:Trying to acquire mutex\n");

	if (!PICAmutexAction(MUTEX_ACQUIRE, &mymut)) *texto += L"Error acquiring mutex in thread\r\n";
	else *texto += L"Mutex acquired in thread\r\n";
  
	*texto += L"Thread: Trying to acquire semaphore\r\n";
	if (!PICAsemaphoreAction(SEMAPHORE_ACQUIRE, &mysem,4)) *texto += L"Error acquiring sem. in thread\r\n";
	else *texto += L"Sem. acquired in thread\r\n";

	*texto += L"Thread: I'm working in critical session!!! :P \r\n";
    Sleep(2000);

	*texto += L"Thread: I ended to work in critical session!!! :P \r\n";
	if (!PICAmutexAction(MUTEX_RELEASE, &mymut)) *texto += L"Error releasing mutex\r\n";
	else *texto += L"Mutex released in thread\r\n";

	if (!PICAsemaphoreAction(SEMAPHORE_RELEASE, &mysem,1)) *texto += L"Error releasing sem\r\n";
	else *texto += L"Sem. released in thread\r\n";

	Sleep(2000);

		while (1) {
		*texto += L"sono il thread: dentro dl while!!\r\n";
		*texto += L"dormo\r\n";
		Sleep(1000);
		*texto += L"sveglio\r\n";
	}
	*texto += L"sono il thread: dopo dl while!!\r\n";

	return 0;
}



void CPICA_lib_testDlg::OnThread() 
{
	int  i;
	THRID mythr;
	CString prova;

	m_text = L"";


	if (PICAstartThread(&mythr, &thrfunc, (void *) &m_text) == 0) printf("Error starting thread!");
  else {
    printf("Success starting thread");
  }
  for (i=0;i<10;i++) {
	  Sleep(200);
	  UpdateData(FALSE);  
  }
  printf("Suspending thread");
  if (!PICAsuspendThread(mythr)) printf("Error suspending thread");
  for (i=0;i<10;i++) {
	  Sleep(200);
  }
  UpdateData(FALSE); 
  
  
  printf("Resuming for 2 sec.");
  if (!PICAresumeThread(mythr)) printf("Error resuming thread");  
  for (i=0;i<10;i++) {
	  Sleep(200);
	  UpdateData(FALSE);  
  }
  UpdateData(FALSE);
  printf("trying to kill ");
  if (!PICAkillThread(mythr)) printf("Error stopping thread!");
  else printf("Thread stopped");
	
}



DWORD WINAPI timerfunc(void * data) {
/*	CString * texto;

	texto = (CString *) data;
	printf((char*)data);

    *texto += L"TIMER_FUNC: Timer activated\r\n";

*/	int * x;
	x=(int*)data;
	(*x)++;
	return 0;
}

void CPICA_lib_testDlg::OnTimerT() 
{
UINT64 dif;

	int i, a=0, b=0, c=0, d=0;
	

	char  buf5[] = "Dados do buffer5";
	char  buf6[] = "Dados do buffer6";
	




dif = PICAgetCurrTime();

	dif += 3000;


	if (!PICAtimer(T_STARTUP, NULL, NULL, NULL)) printf("Error starting timer");
	else printf("Success starting timer");

	if (!PICAtimer(T_SET, &dif, (void *) timerfunc, (void *) &a)) printf("Error setting timer with a");
	else printf("Success setting timer");

	if (!PICAtimer(T_STOP, &dif, (void *) timerfunc, (void *) &a)) printf("Error stopping timer with a");
	else printf("Success stopping timer");

	Sleep(5000);
	UpdateData(FALSE);


	dif = PICAgetCurrTime();

	dif += 3000;

	if (!PICAtimer(T_SET, &dif, (void *) timerfunc, (void *) &d)) printf("Error setting timer\n");
	else printf("Success setting timer with d");

	if (!PICAtimer(T_SET, &dif, (void *) timerfunc, (void *) &b)) printf("Error setting timer\n");
	else printf("Success setting timer with b");

	dif += 3000;

	if (!PICAtimer(T_SET, &dif, (void *) timerfunc, (void *) &c)) printf("Error setting timer\n");
	else printf("Success setting timer with c");

	for (i=0;i<50;i++) {
		Sleep(200);
		UpdateData(FALSE);
	}

	sprintf(text, "a: %d, b:%d, c:%d, d:%d", a, b, c, d);
	printf(text);

	if (!PICAtimer(T_KILL, NULL, NULL, NULL)) printf("Error killing timer\n");
	else printf("Success killing timer");



}

void CPICA_lib_testDlg::OnthreadMutexSyncr() 
{

THRID mythr;
 int i;


   printf("\n------------------ Thread synchronization test -----------------\n");

m_text = L"hola";

  if (!PICAcreateMutex(&mymut)) {
	    printf("Error creating mutex\n");
		return;
   }
  else printf("Mutex created in main\n");

	if (!PICAmutexAction(MUTEX_ACQUIRE, &mymut)) printf("Error acquiring mutex\n");
	else printf("Mutex acquired in main\n");
  
	if (!PICAcreateSemaphore(&mysem, 3, 5)) {
		printf("Error creating semaphore\n");
		return;
	} else printf("Success creating semaphore\n");


	if (!PICAstartThread(&mythr, &thrfunc2, (void *) &m_text)) printf("Error starting thread!\n");
	else {
		printf("Success starting thread\n");
	}

 for (i=0;i<10;i++) {
	  Sleep(200);
	  UpdateData(FALSE);  
  }

	if (!PICAmutexAction(MUTEX_RELEASE, &mymut)) printf("Error releasing mutex\n");
	else printf("Mutex released in main\n");

for (i=0;i<10;i++) {
	  Sleep(200);
	  UpdateData(FALSE);  
  }

	if (!PICAsemaphoreAction(SEMAPHORE_RELEASE, &mysem,1)) printf("Error releasing sem\n");
	else printf("Sem. released in main\n");

for (i=0;i<20;i++) {
	  Sleep(200);
	  UpdateData(FALSE);  
  }
  printf("I'm going to kill thread\n");
 
  if (!PICAkillThread(mythr)) printf("Error stopping thread!");
  else printf("Thread stopped\n");
	

for (i=0;i<10;i++) {
	  Sleep(200);
	  UpdateData(FALSE);  
  }
	if (!PICAdestroyMutex(&mymut)) printf("Error destroying mutex\n");
	else printf("Success destroying mutex\n");

	if (!PICAdestroySemaphore(&mysem)) printf("Error destroying semaphore\n");
	else printf("Success destroying semaphore\n");


	
}

void CPICA_lib_testDlg::OnClose() 
{
	char buf [100];
	int err;
	if(!PICAcleanup())
	{
		PICAgetLastError(buf, &err);
		sprintf(text, "E: %d: %s", err, buf);
		printf(text);
	}
	else printf("PICA closed correctly!!!");
	
}
