#include "PICA/pica.h"
#include <sched.h>
#include <stdio.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <unistd.h>
#include <stdlib.h>


//globals

PICAmutex mymut;
PICAsemaphore mysem;


//---------------------------------- T I ME R    T E S T -----------------------------------------------------------------

void timerfunc(void * data) {
  

  printf("Timer activated. Input data to function is: %s\n",(char *) data);

}

void test_timer(void) {

  char buf[100];
  char  buf5[] = "Data from buffer5";
  char  buf6[] = "Data from buffer6";
  UINT64 dif;
  int code;
	

  	printf("\n------------------ Timer test -----------------\n");

	dif = PICAgetCurrTime();

	dif += 3000;

	printf("Setting timer\n");

	if (!PICAtimer(T_STARTUP, NULL, NULL, NULL)) printf("Error statring timer\n");
	else printf("Success starting timer\n");


	if (!PICAtimer(T_SET, &dif, &timerfunc, buf6)) {
		PICAgetLastError(buf,&code);	
		printf("Error setting timer: %s\n",buf);
	}
	else printf("Success setting timer\n");

	dif -=1500;

	if (!PICAtimer(T_SET, &dif, &timerfunc, buf5)) printf("Error setting timer\n");
	else printf("Success setting timer\n");

	//if (!PICAtimer(T_STOP, &dif, &timerfunc, buf5)) printf("Error stopping timer\n");
	//else printf("Success stopping timer\n");

	if (!PICAtimer(T_KILL, NULL, NULL, NULL)) printf("Error killing timer\n");
	else printf("Success killing timer\n");



	//again

	dif = PICAgetCurrTime();

	dif += 3000;


	if (!PICAtimer(T_STARTUP, NULL, NULL, NULL)) printf("Error starting timer\n");
	else printf("Success starting timer\n");


	if (!PICAtimer(T_SET, &dif, &timerfunc, buf6)) printf("Error setting timer\n");
	else printf("Success setting timer\n");

	dif -=1500;

	if (!PICAtimer(T_SET, &dif, &timerfunc, buf5)) printf("Error setting timer\n");
	else printf("Success setting timer\n");

	if (!PICAtimer(T_STOP, &dif, &timerfunc, buf5)) printf("Error stopping timer\n");
	else printf("Success stopping timer\n");


	sleep(5000);

	if (!PICAtimer(T_KILL, NULL, NULL, NULL)) printf("Error killing timer\n");
	else printf("Success killing timer\n");

}
//--------------------------------- M A I N ----------------------------------------------------
int main (void) {

PICAsocket mysock;
 int adm;

 //Library startup is very important !!!!
  if (!PICAstartup(0)) printf("Error starting library\n");
  else printf("PICA library initialized!\n\n");


  if (!PICAcreateSocket(&mysock,PF_INET, SOCK_DGRAM, 0)) printf("Error creating socket\n");
  else printf("socket created\n");
  if (!PICAcloseSocket(mysock)) printf("Error closing socket\n");
  else printf("Socket closed\n");

   if (!PICAisAdministrator(&adm)) printf("Error getting ADM. data\n");
   else printf("Success getting ADM. data: user is %s\n",adm>0?"Administrator":"not Administrator");

   

   test_timer();
}