#include "PICA/pica.h"
#include <sched.h>
#include <stdio.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <unistd.h>
#include <stdlib.h>


//globals

PICAmutex mymut;
PICAsemaphore mysem;


//----------------------------------  T T L   T E S T -----------------------------------------------------------------
void thrfunc(void * data) {
  char * dados;

  dados = (char *) data;

  printf("Dados da thread: %s\nTrying to acquire mutex\n",dados);

	if (!PICAmutexAction(MUTEX_ACQUIRE, &mymut)) printf("Error acquiring mutex in thread\n");
	else printf("Mutex acquired in thread\n");
  
	printf("Thread: Trying to acquire semaphore\n");
	if (!PICAsemaphoreAction(SEMAPHORE_ACQUIRE, &mysem,4)) printf("Error acquiring sem. in thread\n");
	else printf("Sem. acquired in thread\n");


	while(1) {
		printf("in the thread!\n");
		sleep(1000);
	}

}


void test_thread(void) {

   THRID mythr;


   printf("\n------------------ Thread synchronization test -----------------\n");

   if (!PICAcreateMutex(&mymut)) {
	    printf("Error creating mutex\n");
		return;
   }

	if (!PICAmutexAction(MUTEX_ACQUIRE, &mymut)) printf("Error acquiring mutex\n");
	else printf("Mutex acquired in main\n");
  
	if (!PICAcreateSemaphore(&mysem, 3, 5)) {
		printf("Error creating semaphore\n");
		return;
	} else printf("Success creating semaphore\n");

	if (!PICAstartThread(&mythr, &thrfunc, "parametro")) printf("Error starting thread!\n");
	else {
		printf("Success starting thread\n");
	}


	sleep(2000);

	if (!PICAmutexAction(MUTEX_RELEASE, &mymut)) printf("Error releasing mutex\n");
	else printf("Mutex released in main\n");

	sleep(2000);

	if (!PICAsemaphoreAction(SEMAPHORE_RELEASE, &mysem,1)) printf("Error releasing sem\n");
	else printf("Sem. released in main\n");


  sleep(2000);

  printf("Suspending for 2 sec.\n");
  PICAsuspendThread(mythr);
  sleep(2000);
  PICAresumeThread(mythr);
  printf("Resuming for 2 sec.\n");
  sleep(2000);
  if (!PICAkillThread(mythr)) printf("Error stopping thread!");
  else printf("Thread stopped\n");

	sleep(2000);
	
	if (!PICAdestroyMutex(&mymut)) printf("Error destroying mutex\n");
	else printf("Success destroying mutex\n");

	if (!PICAdestroySemaphore(&mysem)) printf("Error destroying semaphore\n");
	else printf("Success destroying semaphore\n");

}



//--------------------------------- M A I N ----------------------------------------------------
int main (void) {

PICAsocket mysock;
 int adm;

 //Library startup is very important !!!!
  if (!PICAstartup(0)) printf("Error starting library\n");
  else printf("PICA library initialized!\n\n");


  if (!PICAcreateSocket(&mysock,PF_INET, SOCK_DGRAM, 0)) printf("Error creating socket\n");
  else printf("socket created\n");
  if (!PICAcloseSocket(mysock)) printf("Error closing socket\n");
  else printf("Socket closed\n");

   if (!PICAisAdministrator(&adm)) printf("Error getting ADM. data\n");
   else printf("Success getting ADM. data: user is %s\n",adm>0?"Administrator":"not Administrator");

   

   test_thread();
}