#include "PICA/pica.h"
#include <sched.h>
#include <stdio.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <unistd.h>
#include <stdlib.h>


//globals

PICAmutex mymut;
PICAsemaphore mysem;


//----------------------------------  P I P E   T E S T -----------------------------------------------------------------
void test_pipe(void) {

	PICApipe inpipe, outpipe;	
	int len, ret;
	char pdata[] = "estes sao os meus dados";
	char buf[100];
	

	printf("\n------------------ Pipe test -----------------\n");

	len = strlen(pdata);
 
    if (!PICAmakePipe(&inpipe, &outpipe)) printf("Error making pipe\n");
    else printf("Success opening pipes\n");

    if (!PICAsendToPipe(outpipe, pdata, len+200, &ret)) {
		PICAgetLastError(buf,&ret);
		printf("Error sending: %s\n", buf);        
	}
	else printf("Sent %d bytes\n", ret);


    if (!PICAgetFromPipe(inpipe, buf, 100, &ret)) printf("Error receiving\n");
    else {
            buf[ret] = '\0';
            printf("received %d bytes: %s\n",ret,buf);
    }



    if (!PICAclosePipe(inpipe)) printf("Error closing pipe\n");
    else printf("Closed pipe\n");
    if (!PICAclosePipe(outpipe)) printf("Error closing pipe\n");
    else printf("Closed pipe\n");

}

//--------------------------------- M A I N ----------------------------------------------------
int main (void) {

PICAsocket mysock;
 int adm;

 //Library startup is very important !!!!
  if (!PICAstartup(0)) printf("Error starting library\n");
  else printf("PICA library initialized!\n\n");


  if (!PICAcreateSocket(&mysock,PF_INET, SOCK_DGRAM, 0)) printf("Error creating socket\n");
  else printf("socket created\n");
  if (!PICAcloseSocket(mysock)) printf("Error closing socket\n");
  else printf("Socket closed\n");

   if (!PICAisAdministrator(&adm)) printf("Error getting ADM. data\n");
   else printf("Success getting ADM. data: user is %s\n",adm>0?"Administrator":"not Administrator");

   

   test_pipe();
}