#include "PICA/pica.h"
#include <sched.h>
#include <stdio.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <unistd.h>
#include <stdlib.h>


//globals

PICAmutex mymut;
PICAsemaphore mysem;

//------------------------------------------------------ L O G   T E S T --------------------------
void test_log(void) {
 FDesc myfile;
 char data[] = "hola!!";
 char * buf;
 int size;

 printf("\n------------------ Log file test -----------------\n");

buf = (char *) malloc (5*sizeof(char));

 if (!PICAopenFile(&myfile,"test.txt", WRITEF, APPEND)) {
	 printf("Error opening file\n");
	 return;
 } else printf("File open\n");

 if (!PICAwriteToFile(myfile,data, strlen(data))) {
	 printf("Error writing to file\n");
	 return;
 } else printf("Data written to file\n");

 if (!PICAcloseFile(myfile)) printf("Error closing file");
  else printf("File closed\n");


  if (!PICAopenFile(&myfile,"test.txt", READF, 0)) {
	 printf("Error opening file\n");
	 return;
  } else printf("File open\n");


 if (!PICAreadFile(myfile,buf, 20, &size)) {
	 printf("Error reading file\n");
	 return;
 } else {
	 buf[size] = '\0';
	 printf("Data size %d from file: %s\n",size, buf);
 }

 if (!PICAcloseFile(myfile)) printf("Error closing file");
else printf("File closed\n");

} 


//--------------------------------- M A I N ----------------------------------------------------
int main (void) {

PICAsocket mysock;
 int adm;

 //Library startup is very important !!!!
  if (!PICAstartup(0)) printf("Error starting library\n");
  else printf("PICA library initialized!\n\n");


  if (!PICAcreateSocket(&mysock,PF_INET, SOCK_DGRAM, 0)) printf("Error creating socket\n");
  else printf("socket created\n");
  if (!PICAcloseSocket(mysock)) printf("Error closing socket\n");
  else printf("Socket closed\n");

   if (!PICAisAdministrator(&adm)) printf("Error getting ADM. data\n");
   else printf("Success getting ADM. data: user is %s\n",adm>0?"Administrator":"not Administrator");

   

   test_log();
}