#include "PICA/pica.h"
#include <sched.h>
#include <stdio.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <unistd.h>


//globals

PICAmutex mymut;
PICAsemaphore mysem;

DEVLIST devs;
//-----------------------------------  T E S T   D E V I C E -----------------------------------------------------------
void test_devices(void) {

  DevAttrs attrs;
  struct in_addr ip;
  int i;
  char err;
  int code;


   printf("\n------------------ Device test -----------------\n");
  
   if (PICAgetAvailableDevices(&devs) == 0) printf("Error getting available devices\n");
  else {
    printf("devices obtained: %d\n",devs.num_devices);
    for (i=0;i<devs.num_devices;i++) printf("princ: dev %d is %s\n",i, devs.dev_names[i]);
  }
 
/*
  i=socket(AF_PACKET, SOCK_RAW, 0);
  printf("i is %d \n",i);
  */
  //err=PICAgetDeviceAttrs(devs.dev_names[1], &attrs);
  //err=PICAgetDeviceAttrs("eth0", &attrs);
  
  for (i=0;i<devs.num_devices;i++)
{
  if(PICAgetDeviceAttrs(devs.dev_names[i], &attrs)==0) 
  {
	if(PICAgetLastError(&err, &code)==0)printf("Error debugging");
	else
		printf("Device Test error: %s num: %dn ", err, code);
  }
  else
  {
	
	printf("Got device attrs\n");
	ip.s_addr = attrs.ip_addr;
	printf("L2   interface is [%.2x:%.2x:%.2x:%.2x:%2.2x:%.2x] with IP  %s\n", (unsigned char) attrs.ha[0],  (unsigned char)attrs.ha[1],  (unsigned char)attrs.ha[2], (unsigned char) attrs.ha[3], (unsigned char) attrs.ha[4], (unsigned char) attrs.ha[5], inet_ntoa(ip));
  }
}

}

/*void test_devices(void) {

  DevAttrs attrs;
  struct in_addr ip;
  int i;
  char err;
  int code;


   printf("\n------------------ Device test -----------------\n");
  
   if (PICAgetAvailableDevices(&devs) == 0) printf("Error getting available devices\n");
  else {
    printf("devices obtained: %d\n",devs.num_devices);
    for (i=0;i<devs.num_devices;i++) printf("princ: dev %d is %s\n",i, devs.dev_names[i]);
  }
 
/*
  i=socket(AF_PACKET, SOCK_RAW, 0);
  printf("i is %d \n",i);

  //err=PICAgetDeviceAttrs(devs.dev_names[1], &attrs);
  //err=PICAgetDeviceAttrs("eth0", &attrs);
  if(PICAgetDeviceAttrs(devs.dev_names[1], &attrs)==0) 
  {
	if(PICAgetLastError(&err, &code)==0)printf("Error debugging");
	else
	{
		
		}
}
  
  if ( err== 1)
  {
    printf("Got device attrs\n");
	ip.s_addr = attrs.ip_addr;
	printf("L2   interface is [%.2x:%.2x:%.2x:%.2x:%2.2x:%.2x] with IP  %s\n", (unsigned char) attrs.ha[0],  (unsigned char)attrs.ha[1],  (unsigned char)attrs.ha[2], (unsigned char) attrs.ha[3], (unsigned char) attrs.ha[4], (unsigned char) attrs.ha[5], inet_ntoa(ip));
  }
  else
  {
	printf("Error num:  %d", err);  
   }

}*/
//--------------------------------- M A I N ----------------------------------------------------
int main (void) {

PICAsocket mysock;
 int adm;

 //Library startup is very important !!!!
  if (!PICAstartup(0)) printf("Error starting library\n");
  else printf("PICA library initialized!\n\n");


  if (!PICAcreateSocket(&mysock,PF_INET, SOCK_DGRAM, 0)) printf("Error creating socket\n");
  else printf("socket created\n");
  if (!PICAcloseSocket(mysock)) printf("Error closing socket\n");
  else printf("Socket closed\n");

   if (!PICAisAdministrator(&adm)) printf("Error getting ADM. data\n");
   else printf("Success getting ADM. data: user is %s\n",adm>0?"Administrator":"not Administrator");

   

   test_devices();
}