#include "PICA/pica.h"
#include <sched.h>
#include <stdio.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <unistd.h>
#include <stdlib.h>

PICAmutex mymut;
PICAsemaphore mysem;

DEVLIST devs;

//----------------------------------  T T L   T E S T -----------------------------------------------------------------
void test_TTL(void) {

	int ttl;

	  printf("\n------------------ TTL test -----------------\n");

	  ttl = 77;

	if (!PICAdefaultTTL(TTL_SET, &ttl)) printf("Error setting TTL\n");
	else printf("TTL set to %d\n",ttl);

	if (!PICAdefaultTTL(TTL_GET, &ttl)) printf("Error getting TTL\n");
	else printf("System TTL is %d\n",ttl);

	ttl = 64;

	if (!PICAdefaultTTL(TTL_SET, &ttl)) printf("Error setting TTL\n");
	else printf("TTL set to %d\n",ttl);

	if (!PICAdefaultTTL(TTL_GET, &ttl)) printf("Error getting TTL\n");
	else printf("System TTL is %d\n",ttl);

}


//---------------------------------- T I ME R    T E S T -----------------------------------------------------------------

void timerfunc(void * data) {
  

  printf("Timer activated. Input data to function is: %s\n",(char *) data);

}

void test_timer(void) {

  char buf[100];
  char  buf5[] = "Data from buffer5";
  char  buf6[] = "Data from buffer6";
  UINT64 dif;
  int code;
	

  	printf("\n------------------ Timer test -----------------\n");

	dif = PICAgetCurrTime();

	dif += 3000;

	printf("Setting timer\n");

	if (!PICAtimer(T_STARTUP, NULL, NULL, NULL)) printf("Error statring timer\n");
	else printf("Success starting timer\n");


	if (!PICAtimer(T_SET, &dif, &timerfunc, buf6)) {
		PICAgetLastError(buf,&code);	
		printf("Error setting timer: %s\n",buf);
	}
	else printf("Success setting timer\n");

	dif -=1500;

	if (!PICAtimer(T_SET, &dif, &timerfunc, buf5)) printf("Error setting timer\n");
	else printf("Success setting timer\n");

	//if (!PICAtimer(T_STOP, &dif, &timerfunc, buf5)) printf("Error stopping timer\n");
	//else printf("Success stopping timer\n");

	if (!PICAtimer(T_KILL, NULL, NULL, NULL)) printf("Error killing timer\n");
	else printf("Success killing timer\n");



	//again

	dif = PICAgetCurrTime();

	dif += 3000;


	if (!PICAtimer(T_STARTUP, NULL, NULL, NULL)) printf("Error starting timer\n");
	else printf("Success starting timer\n");


	if (!PICAtimer(T_SET, &dif, &timerfunc, buf6)) printf("Error setting timer\n");
	else printf("Success setting timer\n");

	dif -=1500;

	if (!PICAtimer(T_SET, &dif, &timerfunc, buf5)) printf("Error setting timer\n");
	else printf("Success setting timer\n");

	if (!PICAtimer(T_STOP, &dif, &timerfunc, buf5)) printf("Error stopping timer\n");
	else printf("Success stopping timer\n");


	sleep(5000);

	if (!PICAtimer(T_KILL, NULL, NULL, NULL)) printf("Error killing timer\n");
	else printf("Success killing timer\n");

}

//----------------------------------  T H E R E A D     T E S T -----------------------------------------------------------------
void thrfunc(void * data) {
  char * dados;

  dados = (char *) data;

  printf("Dados da thread: %s\nTrying to acquire mutex\n",dados);

	if (!PICAmutexAction(MUTEX_ACQUIRE, &mymut)) printf("Error acquiring mutex in thread\n");
	else printf("Mutex acquired in thread\n");
  
	printf("Thread: Trying to acquire semaphore\n");
	if (!PICAsemaphoreAction(SEMAPHORE_ACQUIRE, &mysem,4)) printf("Error acquiring sem. in thread\n");
	else printf("Sem. acquired in thread\n");


	while(1) {
		printf("in the thread!\n");
		sleep(1000);
	}

}


void test_thread(void) {

   THRID mythr;


   printf("\n------------------ Thread synchronization test -----------------\n");

   if (!PICAcreateMutex(&mymut)) {
	    printf("Error creating mutex\n");
		return;
   }

	if (!PICAmutexAction(MUTEX_ACQUIRE, &mymut)) printf("Error acquiring mutex\n");
	else printf("Mutex acquired in main\n");
  
	if (!PICAcreateSemaphore(&mysem, 3, 5)) {
		printf("Error creating semaphore\n");
		return;
	} else printf("Success creating semaphore\n");

	if (!PICAstartThread(&mythr, &thrfunc, "parametro")) printf("Error starting thread!\n");
	else {
		printf("Success starting thread\n");
	}


	sleep(1000);

	if (!PICAmutexAction(MUTEX_RELEASE, &mymut)) printf("Error releasing mutex\n");
	else printf("Mutex released in main\n");

	sleep(2000);

	if (!PICAsemaphoreAction(SEMAPHORE_RELEASE, &mysem,1)) printf("Error releasing sem\n");
	else printf("Sem. released in main\n");


  sleep(2000);

  printf("Suspending for 2 sec.\n");
  PICAsuspendThread(mythr);
  sleep(2000);
  PICAresumeThread(mythr);
  printf("Resuming for 2 sec.\n");
  sleep(2000);
  if (!PICAkillThread(mythr)) printf("Error stopping thread!");
  else printf("Thread stopped\n");

	sleep(2000);
	
	if (!PICAdestroyMutex(&mymut)) printf("Error destroying mutex\n");
	else printf("Success destroying mutex\n");

	if (!PICAdestroySemaphore(&mysem)) printf("Error destroying semaphore\n");
	else printf("Success destroying semaphore\n");

}


//----------------------------------  P I P E   T E S T -----------------------------------------------------------------
void test_pipe(void) {

	PICApipe inpipe, outpipe;	
	int len, ret;
	char pdata[] = "estes sao os meus dados";
	char buf[100];
	

	printf("\n------------------ Pipe test -----------------\n");

	len = strlen(pdata);
 
    if (!PICAmakePipe(&inpipe, &outpipe)) printf("Error making pipe\n");
    else printf("Success opening pipes\n");

    if (!PICAsendToPipe(outpipe, pdata, len, &ret)) {
		PICAgetLastError(buf,&ret);
		printf("Error sending: %s\n", buf);        
	}
	else printf("Sent bytes\n");


    if (!PICAgetFromPipe(inpipe, buf, 100, &ret)) printf("Error receiving\n");
    else {
            buf[ret] = '\0';
            printf("received %d bytes: %s\n",ret,buf);
    }



    if (!PICAclosePipe(inpipe)) printf("Error closing pipe\n");
    else printf("Closed pipe\n");
    if (!PICAclosePipe(outpipe)) printf("Error closing pipe\n");
    else printf("Closed pipe\n");

}

//------------------------------------------------------ L O G   T E S T --------------------------
void test_log(void) {
 FDesc myfile;
 char data[] = "Data to be written to file bla";
 char buf[64];
 int size;

 printf("\n------------------ Log file test -----------------\n");


 if (!PICAopenFile(&myfile,"test.txt", WRITEF, CREATE_CLEAN)) {
	 printf("Error opening file\n");
	 return;
 } else printf("File open\n");

 if (!PICAwriteToFile(myfile,data, strlen(data))) {
	 printf("Error writing to file\n");
	 return;
 } else printf("Data written to file\n");

 if (!PICAcloseFile(myfile)) printf("Error closing file");
  else printf("File closed\n");


  if (!PICAopenFile(&myfile,"test.txt", READF, 0)) {
	 printf("Error opening file\n");
	 return;
  } else printf("File open\n");


 if (!PICAreadFile(myfile,buf, 64, &size)) {
	 printf("Error reading file\n");
	 return;
 } else {
	 buf[size] = '\0';
	 printf("Data from file: %s\n", buf);
 }

 if (!PICAcloseFile(myfile)) printf("Error closing file");
else printf("File closed\n");

} 

//----------------------------------  B U F F E R I N G   T E S T -----------------------------------------------------------------
void test_buffering(void) {

  char  buf1[] = "Dados do buffer1";
  char  buf2[] = "Dados do buffer2";
  char  buf3[] = "Dados do buffer3";
  char  buf4[] = "Dados do buffer4";
  
  PICAbuffer * pbuf;
  PICApacket * packets;
  int i, size, avail_packets;

  
  printf("\n------------------ Buffer test -----------------\n");


//create a buffer with 4 queue	
  if (!PICAinitBuffer(&pbuf, 4)) printf("Error starting buffer\n");
  else printf("Buffer initiated\n");
 


  size = strlen(buf1);
  
  //add data buf1 and buf2 in queue num 1
  if (!PICAaddToBuffer(pbuf,1, buf1, size)) printf("Error adding to buffer\n");
  else printf("Added data to buffer\n");

 if (!PICAaddToBuffer(pbuf,1, buf2, size)) printf("Error adding to buffer\n");
  else printf("Added data to buffer\n");

    //add data buf1 and buf2 in queue num 2
 if (!PICAaddToBuffer(pbuf,2, buf3, size)) printf("Error adding to buffer\n");
  else printf("Added data to buffer\n");

  if (!PICAaddToBuffer(pbuf,2, buf4, size)) printf("Error adding to buffer\n");
  else printf("Added data to buffer\n");



 for (i=0;i<4;i++)
{
  
   printf("\n \n-------Getting row %d--------\n",i);

//get  the first 3 packets from queue i
   if (!PICAgetFromBuffer(pbuf, i, 3, &packets,&avail_packets)) printf("Error getting from buffer\n");
   else printf("I asked 3 packet from queue %d, but avaiable packets are %d: \n",i, avail_packets);

   if (packets == NULL) printf ("packets is null\n");

   while (packets != NULL)
  {
     printf("Data: %s\n",(char *) packets->data);
     packets = packets->next;
   }
   
 }


 if (!PICAkillBuffer(pbuf)) printf("Error killing buffer\n");
  else printf("Buffer killed\n");


}

//----------------------------------  S E L E C T    T E S T -----------------------------------------------------------------
void test_select(void) {

	
	//void *  myevent;
	//void *  myevent2;
	PICAsocket mysock;
	PICAdescList * dl, * jump, * run;
	PICAselResult res;
	PICApipe in, out;
	char buf[100] = "Data sent to pipe";
	int code, written;

	printf("\n------------------ Select test -----------------\n");
	
	//myevent = CreateEvent(NULL,FALSE,FALSE,NULL);
	//myevent2 = CreateEvent(NULL,FALSE,FALSE,NULL);
	//SetEvent(myevent2);
	if (!PICAmakePipe(&in, &out)) printf("Error creating pipe\n");




if (!PICAcreateSocket(&mysock,PF_INET, SOCK_DGRAM, 0)) printf("Error creating socket\n");
  else printf("socket created\n");
  
  //if (!PICAsendToPipe(out, buf, strlen(buf), &written)) printf("Error writing to pipe\n");

	printf("\nStarting select\n");

	dl = NULL;
		
	if (!PICAaddDesc(&dl, PICA_PIPE_TYPE,PICA_W_READ, &in)) printf("Error adding descriptor\n");
	if (!PICAaddDesc(&dl, PICA_SOCKET_TYPE,PICA_W_READ, &mysock)) printf("Error adding descriptor\n");
	if (!PICAaddDesc(&dl, PICA_SOCKET_TYPE,PICA_W_READ, &mysock)) printf("Error adding descriptor\n");
	//if (!PICAaddDesc(&dl, PICA_OTHER_TYPE,PICA_W_READ, &myevent)) printf("Error adding descriptor\n");
	//if (!PICAaddDesc(&dl, PICA_OTHER_TYPE,PICA_W_READ, &myevent2)) printf("Error adding descriptor\n");


//	printf("main: dl is %x\n",dl);
	//come evento invio qc sulla pipe
	if (!PICAsendToPipe(out, buf, strlen(buf)+1, &written)) printf("Error writing to pipe\n");
	if (!PICAselect(PICA_WAIT_FOREVER, dl,  &res)) {
		PICAgetLastError(buf,&code);
		printf("Error in PICAselect: %s\n", buf);
	}
	else {
		printf("Success in select\n");
		if (res.type == PICA_TIMEOUT_TYPE) printf("Selection result is timeout\n");
		else if (res.type == PICA_PIPE_TYPE) {
			sprintf(buf,"");
			PICAgetFromPipe(in, buf, 100, &written);
			buf[written] = '\0';
			printf("Pipe activated. Data: %s\n",buf);
		}
		//else printf("Results: type = %d desc= %x. event desc= %x\n",res.type,res.desc, &myevent2);

	}   	


	//if (!PICAsendToPipe(out, buf, strlen(buf)+1, &written)) printf("Error writing to pipe\n");
//non attivo nessun evento e scade il timeout
	if (!PICAselect(5000, dl,  &res)) {
		PICAgetLastError(buf,&code);
		printf("Error in PICAselect: %s\n", buf);
	}
	else {
		printf("Success in select\n");
		if (res.type == PICA_TIMEOUT_TYPE) printf("Selection result is timeout\n");
		else if (res.type == PICA_PIPE_TYPE) {
			sprintf(buf,"");
			PICAgetFromPipe(in, buf, 100, &written);			
			printf("Pipe activated. Data: %s\n",buf);
		}
	//	else printf("Results: type = %d desc= %x. event desc= %x\n",res.type,res.desc, &myevent2);
	}

	//CloseHandle(myevent);
	//CloseHandle(myevent2);
	PICAclosePipe(in);
	PICAclosePipe(out);
	PICAcloseSocket(mysock);
}


//-----------------------------------  T E S T   D E V I C E -----------------------------------------------------------
void test_devices(void) {

  DevAttrs attrs;
  struct in_addr ip;
  int i;
  char err;
  int code;


   printf("\n------------------ Device test -----------------\n");
  
   if (PICAgetAvailableDevices(&devs) == 0) printf("Error getting available devices\n");
  else {
    printf("devices obtained: %d\n",devs.num_devices);
    for (i=0;i<devs.num_devices;i++) printf("princ: dev %d is %s\n",i, devs.dev_names[i]);
  }
 
/*
  i=socket(AF_PACKET, SOCK_RAW, 0);
  printf("i is %d \n",i);
  */
  //err=PICAgetDeviceAttrs(devs.dev_names[1], &attrs);
  //err=PICAgetDeviceAttrs("eth0", &attrs);
  
  for (i=0;i<devs.num_devices;i++)
{
  if(PICAgetDeviceAttrs(devs.dev_names[i], &attrs)==0) 
  {
	if(PICAgetLastError(&err, &code)==0)printf("Error debugging");
	else
		printf("Device Test error: %s num: %dn ", err, code);
  }
  else
  {
	
	printf("Got device attrs\n");
	ip.s_addr = attrs.ip_addr;
	printf("L2   interface is [%.2x:%.2x:%.2x:%.2x:%2.2x:%.2x] with IP  %s\n", (unsigned char) attrs.ha[0],  (unsigned char)attrs.ha[1],  (unsigned char)attrs.ha[2], (unsigned char) attrs.ha[3], (unsigned char) attrs.ha[4], (unsigned char) attrs.ha[5], inet_ntoa(ip));
  }
}

}

//----------------------------------  R O U T I N G T A B L E   T E S T -----------------------------------------------------------------
void test_rtable(void)
{

	char buf[100];
	int code, err, i;
	RTInfo rt;
	RTLines * line;
	struct in_addr dest,mask,gw; 
       char s_dest[16], s_mask[16], s_gw[16];
	
	printf("\n------------------ Routing table test -----------------\n");

for (i=0;i<devs.num_devices;i++)
{
printf("%s routing table\n", devs.dev_names[i]);
	
	//PUT GATEWAY ADDRESS REACHABLE FROM THIS HOST!!!!!!!!!!!!!!!!!!
	
//err=PICAaddRoute(inet_addr("192.168.0.33"),inet_addr("255.255.255.255"),inet_addr("158.42.55.147"),1,devs.dev_names[i]);
  if (PICAaddRoute(inet_addr("192.168.0.33"),inet_addr("255.255.255.255"),inet_addr("158.42.55.147"),1,devs.dev_names[i])) 
  {
	  printf("Sucess adding route\n");
  }
  else
 {
	 if(PICAgetLastError(buf,&code))printf("Error num %d adding route: %s\n",code, buf);
	else printf("error debugging\n");
  }

  

  if (!PICAgetRoutingTable(& rt)) {
	if(!PICAgetLastError(buf,&code)) printf("Error reading RT: %s\n",buf);
	else printf("error debugging\n");
  }
  else {
	printf("Success reading RT\n");
  
	printf("Linhas: %d\n", rt.entry_count);
	printf("\tdest\t\tmask\t\tgw\tmetric\tif\n"); 
	line = rt.lines;
    while (line != NULL) {
		dest.s_addr = line->dest;
		strcpy(s_dest,inet_ntoa(dest));
		mask.s_addr = line->mask;
		strcpy(s_mask,inet_ntoa(mask));
		gw.s_addr = line->gw;
		strcpy(s_gw,inet_ntoa(gw));
		printf("%14s\t%14s\t%14s\t%3d\t%4s\n",s_dest,s_mask,s_gw,line->metric,line->device);
		line = line->next;
	  }
  }
  
  if (PICAdelRoute(inet_addr("192.168.0.33"),inet_addr("255.255.255.255"),inet_addr("158.42.55.147"),devs.dev_names[i])) printf("Success removing route\n");
  else 
  {
	if(PICAgetLastError(buf,&code)) printf("Error reading RT: %s\n",buf);
	else printf("error debugging\n");  
}
  }

}



//----------------------------------  F O R W A R D I N G    T E S T -----------------------------------------------------------------
void test_forwarding(void) {
  	
	int true_false;

  printf("\n------------------ Forwarding test -----------------\n");
	
  if (!PICAisForwarding(&true_false)) printf("Error getting forwarding state\n");
  else printf("Forwarding is %s\n",true_false>0?"ON":"OFF");
  
  if (!PICAsetForwarding(FWD_ON)) printf("Error stopping forwarding\n");
  else {
	if (!PICAisForwarding(&true_false)) printf("Error getting forwarding state\n");
  else printf("Forwarding is %s\n",true_false>0?"ON":"OFF");
  
  }

  if (!PICAsetForwarding(FWD_OFF)) printf("Error starting forwarding\n");
  else {
	if (!PICAisForwarding(&true_false)) printf("Error getting forwarding state\n");
	else printf("Forwarding is %s\n",true_false>0?"ON":"OFF");
  
  }
  
}

int main (void) {

PICAsocket mysock;
 int adm;

 //Library startup is very important !!!!
  if (!PICAstartup(0)) printf("Error starting library\n");
  else printf("PICA library initialized!\n\n");


  if (!PICAcreateSocket(&mysock,PF_INET, SOCK_DGRAM, 0)) printf("Error creating socket\n");
  else printf("socket created\n");
  if (!PICAcloseSocket(mysock)) printf("Error closing socket\n");
  else printf("Socket closed\n");

   if (!PICAisAdministrator(&adm)) printf("Error getting ADM. data\n");
   else printf("Success getting ADM. data: user is %s\n",adm>0?"Administrator":"not Administrator");

   
test_log();
	
	test_devices();

	//test_packet_io(); //non l'ho potuto fare --> errore

	test_forwarding();

	test_TTL();

	test_rtable();

	test_pipe();

	test_select(); 

	test_buffering();

	test_timer();

	test_thread();
	
	printf("---- E N D -----");
	
	getchar();
}