#include "PICA/pica.h"
#include <sched.h>
#include <stdio.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <unistd.h>
#include <stdlib.h>


//globals

PICAmutex mymut;
PICAsemaphore mysem;


//----------------------------------  B U F F E R I N G   T E S T -----------------------------------------------------------------
void test_buffering(void) {

  char  buf1[] = "111111111111111";
  char  buf2[] = "2222222222222";
  char  buf3[] = "3333333333333";
  char  buf4[] = "4444444444444";
  
  PICAbuffer * pbuf;
  PICApacket * packets;
  int i, size, avail_packets;

  
  printf("\n------------------ Buffer test -----------------\n");


//create a buffer with 4 queue	
  if (!PICAinitBuffer(&pbuf, 3)) printf("Error starting buffer\n");
  else printf("Buffer initiated\n");
 


  size = strlen(buf1);
  
  //add data buf1 and buf2 in queue num 1
  if (!PICAaddToBuffer(pbuf,1, buf1, size+100)) printf("Error adding to buffer\n");
  else printf("Added data to buffer\n");

 if (!PICAaddToBuffer(pbuf,1, buf2, size)) printf("Error adding to buffer\n");
  else printf("Added data to buffer\n");

    //add data buf1 and buf2 in queue num 2
 if (!PICAaddToBuffer(pbuf,2, buf3, size)) printf("Error adding to buffer\n");
  else printf("Added data to buffer\n");

  if (!PICAaddToBuffer(pbuf,2, buf4, size)) printf("Error adding to buffer\n");
  else printf("Added data to buffer\n");


for (i=0;i<3;i++) {
  
   printf("\nTring to get 3 packet from queue %d\n",i);

   if (!PICAgetFromBuffer(pbuf, i, 3, &packets,&avail_packets)) printf("Error getting from buffer\n");
   else printf("Got data from buffer: avail_packets: %d\n",avail_packets);

   if(avail_packets != 0)
   {
	   if (packets == NULL) printf ("packets is null\n");

	   while (packets != NULL) {
		   printf("packet size: %d  ", packets->packet_size);
		 printf("  Data: %s\n",(char *) packets->data);
		 packets = packets->next;
	   }
	  
	   printf("trying to get from queue %d an other time\n", i);
	    i--;	
   }   
 }

 if (!PICAkillBuffer(pbuf)) printf("Error killing buffer\n");
  else printf("Buffer killed\n");



}

//--------------------------------- M A I N ----------------------------------------------------
int main (void) {

PICAsocket mysock;
 int adm;

 //Library startup is very important !!!!
  if (!PICAstartup(0)) printf("Error starting library\n");
  else printf("PICA library initialized!\n\n");


  if (!PICAcreateSocket(&mysock,PF_INET, SOCK_DGRAM, 0)) printf("Error creating socket\n");
  else printf("socket created\n");
  if (!PICAcloseSocket(mysock)) printf("Error closing socket\n");
  else printf("Socket closed\n");

   if (!PICAisAdministrator(&adm)) printf("Error getting ADM. data\n");
   else printf("Success getting ADM. data: user is %s\n",adm>0?"Administrator":"not Administrator");

   

   test_buffering();
}