#include "PICA/pica.h"
#include <sched.h>
#include <stdio.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <unistd.h>
#include <stdlib.h>


//globals

PICAmutex mymut;
PICAsemaphore mysem;


//----------------------------------  T T L   T E S T -----------------------------------------------------------------
void test_TTL(void) {

	int ttl;

	  printf("\n------------------ TTL test -----------------\n");

	  ttl = 77;

	if (!PICAdefaultTTL(TTL_SET, &ttl)) printf("Error setting TTL\n");
	else printf("TTL set to %d\n",ttl);

	if (!PICAdefaultTTL(TTL_GET, &ttl)) printf("Error getting TTL\n");
	else printf("System TTL is %d\n",ttl);

	ttl = 64;

	if (!PICAdefaultTTL(TTL_SET, &ttl)) printf("Error setting TTL\n");
	else printf("TTL set to %d\n",ttl);

	if (!PICAdefaultTTL(TTL_GET, &ttl)) printf("Error getting TTL\n");
	else printf("System TTL is %d\n",ttl);

}


//--------------------------------- M A I N ----------------------------------------------------
int main (void) {

PICAsocket mysock;
 int adm;

 //Library startup is very important !!!!
  if (!PICAstartup(0)) printf("Error starting library\n");
  else printf("PICA library initialized!\n\n");


  if (!PICAcreateSocket(&mysock,PF_INET, SOCK_DGRAM, 0)) printf("Error creating socket\n");
  else printf("socket created\n");
  if (!PICAcloseSocket(mysock)) printf("Error closing socket\n");
  else printf("Socket closed\n");

   if (!PICAisAdministrator(&adm)) printf("Error getting ADM. data\n");
   else printf("Success getting ADM. data: user is %s\n",adm>0?"Administrator":"not Administrator");

   

   test_TTL();
}