#include "PICA/pica.h"
#include <sched.h>
#include <stdio.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <unistd.h>
#include <stdlib.h>


//globals

PICAmutex mymut;
PICAsemaphore mysem;


//----------------------------------  S E L E C T    T E S T -----------------------------------------------------------------
void test_select(void) {

	
	//void *  myevent;
	//void *  myevent2;
	PICAsocket mysock;
	PICAdescList * dl, * jump, * run;
	PICAselResult res;
	PICApipe in, out;
	char buf[100] = "Data sent to pipe";
	int code, written;

	printf("\n------------------ Select test -----------------\n");
	
	//myevent = CreateEvent(NULL,FALSE,FALSE,NULL);
	//myevent2 = CreateEvent(NULL,FALSE,FALSE,NULL);
	//SetEvent(myevent2);
	if (!PICAmakePipe(&in, &out)) printf("Error creating pipe\n");




if (!PICAcreateSocket(&mysock,PF_INET, SOCK_DGRAM, 0, 2)) printf("Error creating socket\n");
  else printf("socket created\n");
  
  //if (!PICAsendToPipe(out, buf, strlen(buf), &written)) printf("Error writing to pipe\n");

	printf("\nStarting select\n");

	dl = NULL;
		
	if (!PICAaddDesc(&dl, PICA_PIPE_TYPE,&in)) printf("Error adding descriptor\n");
	if (!PICAaddDesc(&dl, PICA_SOCKET_TYPE, &mysock)) printf("Error adding descriptor\n");
	if (!PICAaddDesc(&dl, PICA_SOCKET_TYPE, &mysock)) printf("Error adding descriptor\n");
	//if (!PICAaddDesc(&dl, PICA_OTHER_TYPE, &myevent)) printf("Error adding descriptor\n");
	//if (!PICAaddDesc(&dl, PICA_OTHER_TYPE, &myevent2)) printf("Error adding descriptor\n");


//	printf("main: dl is %x\n",dl);
	//come evento invio qc sulla pipe
	if (!PICAsendToPipe(out, buf, strlen(buf)+1, &written)) printf("Error writing to pipe\n");
	if (!PICAselect(PICA_WAIT_FOREVER, dl,  &res)) {
		PICAgetLastError(buf,&code);
		printf("Error in PICAselect: %s\n", buf);
	}
	else {
		printf("Success in select\n");
		if (res.type == PICA_TIMEOUT_TYPE) printf("Selection result is timeout\n");
		else if (res.type == PICA_PIPE_TYPE) {
			sprintf(buf,"");
			PICAgetFromPipe(in, buf, 100, &written);
			buf[written] = '\0';
			printf("Pipe activated. Data: %s\n",buf);
		}
		//else printf("Results: type = %d desc= %x. event desc= %x\n",res.type,res.desc, &myevent2);

	}   	


	//if (!PICAsendToPipe(out, buf, strlen(buf)+1, &written)) printf("Error writing to pipe\n");
//non attivo nessun evento e scade il timeout
	if (!PICAselect(5000, dl,  &res)) {
		PICAgetLastError(buf,&code);
		printf("Error in PICAselect: %s\n", buf);
	}
	else {
		printf("Success in select\n");
		if (res.type == PICA_TIMEOUT_TYPE) printf("Selection result is timeout\n");
		else if (res.type == PICA_PIPE_TYPE) {
			sprintf(buf,"");
			PICAgetFromPipe(in, buf, 100, &written);			
			printf("Pipe activated. Data: %s\n",buf);
		}
	//	else printf("Results: type = %d desc= %x. event desc= %x\n",res.type,res.desc, &myevent2);
	}

	//CloseHandle(myevent);
	//CloseHandle(myevent2);
	PICAclosePipe(in);
	PICAclosePipe(out);
	PICAcloseSocket(mysock);
}
//--------------------------------- M A I N ----------------------------------------------------
int main (void) {

PICAsocket mysock;
 int adm;

 //Library startup is very important !!!!
  if (!PICAstartup(0)) printf("Error starting library\n");
  else printf("PICA library initialized!\n\n");


  if (!PICAcreateSocket(&mysock,PF_INET, SOCK_DGRAM, 0, 2)) printf("Error creating socket\n");
  else printf("socket created\n");
  if (!PICAcloseSocket(mysock)) printf("Error closing socket\n");
  else printf("Socket closed\n");

   if (!PICAisAdministrator(&adm)) printf("Error getting ADM. data\n");
   else printf("Success getting ADM. data: user is %s\n",adm>0?"Administrator":"not Administrator");

   

   test_select();
}