#include "PICA/pica.h"
#include <sched.h>
#include <stdio.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <unistd.h>


//globals

PICAmutex mymut;
PICAsemaphore mysem;

DEVLIST devs;

//function called for thread creation
/*
void thrfunc(void * data) {
  char * dados;

  dados = (char *) data;

  printf("Dados da thread: %s\nTrying to acquire mutex\n",dados);

	if (!PICAmutexAction(MUTEX_ACQUIRE, &mymut)) printf("Error acquiring mutex in thread\n");
	else printf("Mutex acquired in thread\n");
  
	printf("Thread: Trying to acquire semaphore\n");
	if (!PICAsemaphoreAction(SEMAPHORE_ACQUIRE, &mysem,4)) printf("Error acquiring sem. in thread\n");
	else printf("Sem. acquired in thread\n");


	while(1) {
		printf("in the thread!\n");
		Sleep(1000);
	}

}
*/
//function activated on timer UP

void timerfunc(void * data) {
  

  printf("Timer activated. Input data to function is: %s\n",(char *) data);

}

//function showing how to use the PICA timer
/*
void test_timer(void) {

  char buf[100];
  char  buf5[] = "Data from buffer5";
  char  buf6[] = "Data from buffer6";
  UINT64 dif;
  int code;
	

  	printf("\n------------------ Timer test -----------------\n");

	dif = PICAgetCurrTime();

	dif += 3000;

	printf("Setting timer\n");

	if (!PICAtimer(T_STARTUP, NULL, NULL, NULL)) printf("Error statring timer\n");
	else printf("Success starting timer\n");


	if (!PICAtimer(T_SET, &dif, &timerfunc, buf6)) {
		PICAgetLastError(buf,&code);	
		printf("Error setting timer: %s\n",buf);
	}
	else printf("Success setting timer\n");

	dif -=1500;

	if (!PICAtimer(T_SET, &dif, &timerfunc, buf5)) printf("Error setting timer\n");
	else printf("Success setting timer\n");

	//if (!PICAtimer(T_STOP, &dif, &timerfunc, buf5)) printf("Error stopping timer\n");
	//else printf("Success stopping timer\n");

	if (!PICAtimer(T_KILL, NULL, NULL, NULL)) printf("Error killing timer\n");
	else printf("Success killing timer\n");



	//again

	dif = PICAgetCurrTime();

	dif += 3000;


	if (!PICAtimer(T_STARTUP, NULL, NULL, NULL)) printf("Error starting timer\n");
	else printf("Success starting timer\n");


	if (!PICAtimer(T_SET, &dif, &timerfunc, buf6)) printf("Error setting timer\n");
	else printf("Success setting timer\n");

	dif -=1500;

	if (!PICAtimer(T_SET, &dif, &timerfunc, buf5)) printf("Error setting timer\n");
	else printf("Success setting timer\n");

	if (!PICAtimer(T_STOP, &dif, &timerfunc, buf5)) printf("Error stopping timer\n");
	else printf("Success stopping timer\n");


	Sleep(5000);

	if (!PICAtimer(T_KILL, NULL, NULL, NULL)) printf("Error killing timer\n");
	else printf("Success killing timer\n");

}
*/


//function showing how to use the PICA buffering capabilities

void test_buffering(void) {

  char  buf1[] = "Dados do buffer1";
  char  buf2[] = "Dados do buffer2";
  char  buf3[] = "Dados do buffer3";
  char  buf4[] = "Dados do buffer4";
  PICAbuffer * pbuf;
  PICApacket * packets;
  int i, size, avail_packets;

  
  printf("\n------------------ Buffer test -----------------\n");
	
  if (!PICAinitBuffer(&pbuf, 3)) printf("Error starting buffer\n");
  else printf("Buffer initiated\n");
 


  size = strlen(buf1);
  
  if (!PICAaddToBuffer(pbuf,2, buf1, size)) printf("Error adding to buffer\n");
  else printf("Added data to buffer\n");

 if (!PICAaddToBuffer(pbuf,2, buf2, size)) printf("Error adding to buffer\n");
  else printf("Added data to buffer\n");

 if (!PICAaddToBuffer(pbuf,2, buf3, size)) printf("Error adding to buffer\n");
  else printf("Added data to buffer\n");

  if (!PICAaddToBuffer(pbuf,2, buf4, size)) printf("Error adding to buffer\n");
  else printf("Added data to buffer\n");



 for (i=0;i<3;i++) {
  
   printf("\nGetting row %d\n",i);

   if (!PICAgetFromBuffer(pbuf, i, 3, &packets,&avail_packets)) printf("Error getting from buffer\n");
   else printf("Main: Got data from buffer: avail_packets: %d\n",avail_packets);

   if (packets == NULL) printf ("packets is null\n");

   while (packets != NULL) {
     printf("Data: %s\n",(char *) packets->data);
     packets = packets->next;
   }
   
 }


 if (!PICAkillBuffer(pbuf)) printf("Error killing buffer\n");
  else printf("Buffer killed\n");


}


//function showing how to use the PICA select call
/*
void test_select(void) {

	
	void *  myevent, myevent2;
	PICAsocket mysock;
	PICAdescList * dl, * jump, * run;
	PICAselResult res;
	PICApipe in, out;
	char buf[100] = "Data sent to pipe";
	int code, written;

	printf("\n------------------ Select test -----------------\n");
	
	myevent = CreateEvent(NULL,FALSE,FALSE,NULL);
	myevent2 = CreateEvent(NULL,FALSE,FALSE,NULL);
	SetEvent(myevent2);
	if (!PICAmakePipe(&in, &out)) printf("Error creating pipe\n");




if (!PICAcreateSocket(&mysock,PF_INET, SOCK_DGRAM, 0)) printf("Error creating socket\n");
  else printf("socket created\n");
  
  //if (!PICAsendToPipe(out, buf, strlen(buf), &written)) printf("Error writing to pipe\n");

	printf("\nStarting select\n");

	dl = NULL;
		
	if (!PICAaddDesc(&dl, PICA_PIPE_TYPE,PICA_W_READ, &in)) printf("Error adding descriptor\n");
	if (!PICAaddDesc(&dl, PICA_SOCKET_TYPE,PICA_W_READ, &mysock)) printf("Error adding descriptor\n");
	if (!PICAaddDesc(&dl, PICA_SOCKET_TYPE,PICA_W_READ, &mysock)) printf("Error adding descriptor\n");
	if (!PICAaddDesc(&dl, PICA_OTHER_TYPE,PICA_W_READ, &myevent)) printf("Error adding descriptor\n");
	if (!PICAaddDesc(&dl, PICA_OTHER_TYPE,PICA_W_READ, &myevent2)) printf("Error adding descriptor\n");


//	printf("main: dl is %x\n",dl);

	if (!PICAselect(PICA_WAIT_FOREVER, dl,  &res)) {
		PICAgetLastError(buf,&code);
		printf("Error in PICAselect: %s\n", buf);
	}
	else {
		printf("Success in select\n");
		if (res.type == PICA_TIMEOUT_TYPE) printf("Selection result is timeout\n");
		else if (res.type == PICA_PIPE_TYPE) {
			sprintf(buf,"");
			PICAgetFromPipe(in, buf, 100, &written);
			buf[written] = '\0';
			printf("Pipe activated. Data: %s\n",buf);
		}
		else printf("Results: type = %d desc= %x. event desc= %x\n",res.type,res.desc, &myevent2);
	}   	


	if (!PICAsendToPipe(out, buf, strlen(buf)+1, &written)) printf("Error writing to pipe\n");

	if (!PICAselect(5000, dl,  &res)) {
		PICAgetLastError(buf,&code);
		printf("Error in PICAselect: %s\n", buf);
	}
	else {
		printf("Success in select\n");
		if (res.type == PICA_TIMEOUT_TYPE) printf("Selection result is timeout\n");
		else if (res.type == PICA_PIPE_TYPE) {
			sprintf(buf,"");
			PICAgetFromPipe(in, buf, 100, &written);			
			printf("Pipe activated. Data: %s\n",buf);
		}
		else printf("Results: type = %d desc= %x. event desc= %x\n",res.type,res.desc, &myevent2);
	}

	CloseHandle(myevent);
	CloseHandle(myevent2);
	PICAclosePipe(in);
	PICAclosePipe(out);
	PICAcloseSocket(mysock);
}
*/
//function showing how to use the PICA pipes
/*
void test_pipe(void) {

	PICApipe inpipe, outpipe;	
	int len, ret;
	char pdata[] = "estes sao os meus dados";
	char buf[100];
	

	printf("\n------------------ Pipe test -----------------\n");

	len = strlen(pdata);
 
    if (!PICAmakePipe(&inpipe, &outpipe)) printf("Error making pipe\n");
    else printf("Success opening pipes\n");

    if (!PICAsendToPipe(outpipe, pdata, len, &ret)) {
		PICAgetLastError(buf,&ret);
		printf("Error sending: %s\n", buf);        
	}
	else printf("Sent bytes\n");

	if (WaitForSingleObject(inpipe.event,0) == WAIT_OBJECT_0) printf("Pipe event activated\n");
	else printf("Pipe event not activated\n");

    if (!PICAgetFromPipe(inpipe, buf, 100, &ret)) printf("Error receiving\n");
    else {
            buf[ret] = '\0';
            printf("received %d bytes: %s\n",ret,buf);
    }



    if (!PICAclosePipe(inpipe)) printf("Error closing pipe\n");
    else printf("Closed pipe\n");
    if (!PICAclosePipe(outpipe)) printf("Error closing pipe\n");
    else printf("Closed pipe\n");

}
*/
//function showing how to use the PICA routing table manipulation calls

void test_rtable(void) {

	char buf[100];
	int code;
	RTInfo rt;
	RTLines * line;
 struct in_addr dest,mask,gw; 
  char s_dest[16], s_mask[16], s_gw[16];
	
	printf("\n------------------ Routing table test -----------------\n");

  if (PICAaddRoute(inet_addr("192.168.0.33"),inet_addr("255.255.255.255"),inet_addr("192.168.0.99"),1,"{A1DB4DED-6DCD-48FC-9542-19575A4CE093}")) printf("Sucess adding route\n");
  else {
	  PICAgetLastError(buf,&code);
	  printf("Error adding route: %s\n",buf);
  }

  if (PICAdelRoute(inet_addr("192.168.0.33"),inet_addr("255.255.255.255"),inet_addr("192.168.0.99"),"{A1DB4DED-6DCD-48FC-9542-19575A4CE093}")) printf("Success removing route\n");
  else printf("Error removing route\n");

  if (!PICAgetRoutingTable(& rt)) {
		PICAgetLastError(buf,&code);
	  printf("Error reading RT: %s\n",buf);
  }
  else {
	printf("Success reading RT\n");
  
	printf("Linhas: %d\n", rt.entry_count);
	printf("\tdest\t\tmask\t\tgw\tmetric\tif\n"); 
	line = rt.lines;
    while (line != NULL) {
		dest.s_addr = line->dest;
		strcpy(s_dest,inet_ntoa(dest));
		mask.s_addr = line->mask;
		strcpy(s_mask,inet_ntoa(mask));
		gw.s_addr = line->gw;
		strcpy(s_gw,inet_ntoa(gw));
		printf("%14s\t%14s\t%14s\t%3d\t%4s\n",s_dest,s_mask,s_gw,line->metric,line->device);
		line = line->next;
	  }
  }

}

//function showing how to use the PICA forwarding calls

void test_forwarding(void) {
  	
	int true_false;

  printf("\n------------------ Forwarding test -----------------\n");
	
  if (!PICAisForwarding(&true_false)) printf("Error getting forwarding state\n");
  else printf("Forwarding is %s\n",true_false>0?"ON":"OFF");
  
  if (!PICAsetForwarding(FWD_ON)) printf("Error stopping forwarding\n");
  else {
	if (!PICAisForwarding(&true_false)) printf("Error getting forwarding state\n");
  else printf("Forwarding is %s\n",true_false>0?"ON":"OFF");
  
  }

  if (!PICAsetForwarding(FWD_OFF)) printf("Error starting forwarding\n");
  else {
	if (!PICAisForwarding(&true_false)) printf("Error getting forwarding state\n");
	else printf("Forwarding is %s\n",true_false>0?"ON":"OFF");
  
  }
  
}


//function showing how to use the PICA forwarding calls

void test_TTL(void) {

	int ttl;

	  printf("\n------------------ TTL test -----------------\n");

	  ttl = 77;

	if (!PICAdefaultTTL(TTL_SET, &ttl)) printf("Error setting TTL\n");
	else printf("TTL set to %d\n",ttl);

	if (!PICAdefaultTTL(TTL_GET, &ttl)) printf("Error getting TTL\n");
	else printf("System TTL is %d\n",ttl);

	ttl = 64;

	if (!PICAdefaultTTL(TTL_SET, &ttl)) printf("Error setting TTL\n");
	else printf("TTL set to %d\n",ttl);

	if (!PICAdefaultTTL(TTL_GET, &ttl)) printf("Error getting TTL\n");
	else printf("System TTL is %d\n",ttl);

}


//function showing how to use the PICA device calls

void test_devices(void) {

  DevAttrs attrs;
  struct in_addr ip;
  int i;


   printf("\n------------------ Device test -----------------\n");
  
   if (PICAgetAvailableDevices(&devs) == 0) printf("Error getting available devices\n");
  else {
    printf("devices obtained: %d\n",devs.num_devices);
    for (i=0;i<devs.num_devices;i++) printf("princ: dev %d is %s\n",i, devs.dev_names[i]);
  }
 

  
  if (PICAgetDeviceAttrs(devs.dev_names[0], &attrs) == 0) printf("Error device attributes\n");
  else {
    printf("Got device attrs\n");
	ip.s_addr = attrs.ip_addr;
	printf("L2   interface is [%.2x:%.2x:%.2x:%.2x:%2.2x:%.2x] with IP  %s\n", (unsigned char) attrs.ha[0],  (unsigned char)attrs.ha[1],  (unsigned char)attrs.ha[2], (unsigned char) attrs.ha[3], (unsigned char) attrs.ha[4], (unsigned char) attrs.ha[5], inet_ntoa(ip));
  }

}

//function showing how to use the PICA capabilities in packet send/receive
/*
void test_packet_io(void) {

	int i, j, size;
	char * aux; 
	char buf[2048];
	PICA_IO_DEVICE iodev;


  printf("\n------------------ Packet send and receive test -----------------\n");

	aux = devs.dev_names[0]; //name of the interface used to send packets


	//Initialize packet data

	ZeroMemory(buf,255);

	buf[0] = 0x00;
	buf[2] = 0xFF;
	buf[3] = 0xFF;
	buf[4] = 0x42;
	buf[5] = 0xFF;

	buf[6] = 0x00;
	buf[1] = 0x20;
	buf[7] = 0x02;
	buf[8] = 0x2D;
	buf[9] = 0x08;
	buf[10] = 0x42;
	buf[11] = 0x73;

/*
	buf[6] = 0x00;
	buf[7] = 0x04;
	buf[8] = 0x76;
	buf[9] = 0x0B;
	buf[10] = 0xE7;
	buf[11] = 0x4A;



	if (!PICAopenDevice(aux, &iodev)) printf("Error opening device\n");
	else printf("Success opening device\n");


	if (!PICAframe(PICA_SEND, iodev, buf, 80, &size)) printf("Error sending packet\n");
	else printf("Packet sent\n");


	
	//ZeroMemory(buf,2048);

	for (j=0;j<1;j++) {
		
		if (!PICAframe(PICA_RECEIVE, iodev, buf, 2048, &size)) printf("Error receiving packet\n");
		else {
			printf("Packet received with size: %d\n",size);
			for (i=0;i<size;i++) {
				printf("%x ", (unsigned char) buf[i]);
			}
			printf("\n");
		}

	}//fim while

	if (!PICAcloseDevice(iodev)) printf("Error closing device\n");
	else printf("Success closing device\n");


}*/

//function showing how to use the PICA threads, mutexes and semaphores
/*
void test_thread(void) {

   THRID mythr;


   printf("\n------------------ Thread synchronization test -----------------\n");

   if (!PICAcreateMutex(&mymut)) {
	    printf("Error creating mutex\n");
		return;
   }

	if (!PICAmutexAction(MUTEX_ACQUIRE, &mymut)) printf("Error acquiring mutex\n");
	else printf("Mutex acquired in main\n");
  
	if (!PICAcreateSemaphore(&mysem, 3, 5)) {
		printf("Error creating semaphore\n");
		return;
	} else printf("Success creating semaphore\n");

	if (!PICAstartThread(&mythr, &thrfunc, "parametro")) printf("Error starting thread!\n");
	else {
		printf("Success starting thread\n");
	}


	Sleep(2000);

	if (!PICAmutexAction(MUTEX_RELEASE, &mymut)) printf("Error releasing mutex\n");
	else printf("Mutex released in main\n");

	Sleep(2000);

	if (!PICAsemaphoreAction(SEMAPHORE_RELEASE, &mysem,1)) printf("Error releasing sem\n");
	else printf("Sem. released in main\n");


  Sleep(2000);

  printf("Suspending for 2 sec.\n");
  PICAsuspendThread(mythr);
  Sleep(2000);
  PICAresumeThread(mythr);
  printf("Resuming for 2 sec.\n");
  Sleep(2000);
  if (!PICAkillThread(mythr)) printf("Error stopping thread!");
  else printf("Thread stopped\n");

	Sleep(2000);
	
	if (!PICAdestroyMutex(&mymut)) printf("Error destroying mutex\n");
	else printf("Success destroying mutex\n");

	if (!PICAdestroySemaphore(&mysem)) printf("Error destroying semaphore\n");
	else printf("Success destroying semaphore\n");

}


*/
//function showing how to use the PICA logging capabilities

void test_log(void) {
 FDesc myfile;
 char data[] = "Data to be written to file bla";
 char buf[64];
 int size;

 printf("\n------------------ Log file test -----------------\n");


 if (!PICAopenFile(&myfile,"test.txt", WRITEF, CREATE_CLEAN)) {
	 printf("Error opening file\n");
	 return;
 } else printf("File open\n");

 if (!PICAwriteToFile(myfile,data, strlen(data))) {
	 printf("Error writing to file\n");
	 return;
 } else printf("Data written to file\n");

 if (!PICAcloseFile(myfile)) printf("Error closing file");
  else printf("File closed\n");


  if (!PICAopenFile(&myfile,"test.txt", READF, 0)) {
	 printf("Error opening file\n");
	 return;
  } else printf("File open\n");


 if (!PICAreadFile(myfile,buf, 64, &size)) {
	 printf("Error reading file\n");
	 return;
 } else {
	 buf[size] = '\0';
	 printf("Data from file: %s\n", buf);
 }

 if (!PICAcloseFile(myfile)) printf("Error closing file");
else printf("File closed\n");

} 
/*
int test_router(int on_off) {

	OVERLAPPED	Overlapped;
	void * 		Handle;
	DWORD		dwCount;

	memset(&Overlapped,0, sizeof(OVERLAPPED));
	Overlapped.hEvent = CreateEvent(NULL, FALSE, FALSE, NULL);

	if (on_off == FWD_ON) {
		if (EnableRouter(&Handle, &Overlapped) != ERROR_IO_PENDING) {
			printf("PICAsetForwarding: Error setting forwarding state\n");
			return 0;
		}
	}
	else {
		if (UnenableRouter(&Overlapped, &dwCount) != NO_ERROR) {
			printf("PICAsetForwarding: Error setting forwarding state\n");
			return 0;
		}
	}

	return 1;
}
*/
/*
------------------------- Main ------------------------------
*/


int main (void) {

 PICAsocket mysock;
 int adm;

 //Library startup is very important !!!!
  if (!PICAstartup(0)) printf("Error starting library\n");
  else printf("PICA library initialized!\n\n");


  if (!PICAcreateSocket(&mysock,PF_INET, SOCK_DGRAM, 0)) printf("Error creating socket\n");
  else printf("socket created\n");
  if (!PICAcloseSocket(mysock)) printf("Error closing socket\n");
  else printf("Socket closed\n");

   if (!PICAisAdministrator(&adm)) printf("Error getting ADM. data\n");
   else printf("Success getting ADM. data: user is %s\n",adm>0?"Administrator":"not Administrator");

	test_log();
	
	test_devices();

	//test_packet_io(); //non l'ho potuto fare --> errore

	test_forwarding();

	test_TTL();

	test_rtable();

	//test_pipe();

	//test_select(); //DA RIVEDERE

	//test_buffering();

	//test_timer();

	//test_thread();
/*
	if (!PICAcleanup()) printf("Error cleaning library\n");
	else printf("\nPICA library cleaned up!\n");
*/
	test_forwarding();
	/*printf("Enabling router\n");
	if (test_router(1)) {
		test_forwarding();
	} else printf("Error starting router\n");

	printf("Disabling router\n");
	if (test_router(0)) {
		test_forwarding();
	} else printf("Error starting router\n");
	*/
   getchar();

}
