#include "PICA/pica.h"
#include <sched.h>
#include <stdio.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <unistd.h>
#include <stdlib.h>


//globals

PICAmutex mymut;
PICAsemaphore mysem;

DEVLIST devs;
//-----------------------------------  T E S T   D E V I C E -----------------------------------------------------------
void test_devices(void) {

  DevAttrs attrs;
  struct in_addr ip;
  int i;
  char err;
  int code;


   printf("\n------------------ Device test -----------------\n");
  
   if (PICAgetAvailableDevices(&devs) == 0) printf("Error getting available devices\n");
  else {
    printf("devices obtained: %d\n",devs.num_devices);
    for (i=0;i<devs.num_devices;i++) printf("princ: dev %d is %s\n",i, devs.dev_names[i]);
  }
 
/*
  i=socket(AF_PACKET, SOCK_RAW, 0);
  printf("i is %d \n",i);
  */
  //err=PICAgetDeviceAttrs(devs.dev_names[1], &attrs);
  //err=PICAgetDeviceAttrs("eth0", &attrs);
  
  for (i=0;i<devs.num_devices;i++)
{
  if(PICAgetDeviceAttrs(devs.dev_names[i], &attrs)==0) 
  {
	if(PICAgetLastError(&err, &code)==0)printf("Error debugging");
	else
		printf("Device Test error: %s num: %dn ", err, code);
  }
  else
  {
	
	printf("Got device attrs\n");
	ip.s_addr = attrs.ip_addr;
	printf("L2   interface is [%.2x:%.2x:%.2x:%.2x:%2.2x:%.2x] with IP  %s\n", (unsigned char) attrs.ha[0],  (unsigned char)attrs.ha[1],  (unsigned char)attrs.ha[2], (unsigned char) attrs.ha[3], (unsigned char) attrs.ha[4], (unsigned char) attrs.ha[5], inet_ntoa(ip));
  }
}

}

//----------------------------------  R O U T I N G T A B L E   T E S T -----------------------------------------------------------------
void test_rtable(void)
{

	char buf[100];
	int code, err, i;
	RTInfo rt;
	RTLines * line;
	struct in_addr dest,mask,gw; 
       char s_dest[16], s_mask[16], s_gw[16];
	
	printf("\n------------------ Routing table test -----------------\n");

for (i=0;i<devs.num_devices;i++)
{
	printf("%s routing table\n", devs.dev_names[i]);
	
	//PUT GATEWAY ADDRESS REACHABLE FROM THIS HOST!!!!!!!!!!!!!!!!!!
	
	//err=PICAaddRoute(inet_addr("192.168.0.33"),inet_addr("255.255.255.255"),inet_addr("158.42.55.147"),1,devs.dev_names[i]);
	if (PICAaddRoute(inet_addr("10.10.10.0"),inet_addr("255.255.255.0"),inet_addr("158.42.55.250"),1,devs.dev_names[i])) 
	{
		printf("Sucess adding route\n");
	}
	else
	{
		if(PICAgetLastError(buf,&code))printf("Error num %d adding route: %s\n",code, buf);
		else printf("error debugging\n");
	}
	printf("\n\n second time:\n");
	
	if (PICAaddRoute(inet_addr("10.10.10.0"),inet_addr("255.255.255.0"),inet_addr("158.42.55.250"),1,devs.dev_names[i])) 
	{
		printf("Sucess adding route\n");
	}
	else
	{
		if(PICAgetLastError(buf,&code))printf("Error num %d adding route: %s\n",code, buf);
		else printf("error debugging\n");
	}
	
  

  if (!PICAgetRoutingTable(& rt)) {
	if(!PICAgetLastError(buf,&code)) printf("Error reading RT: %s\n",buf);
	else printf("error debugging\n");
  }
  else {
	printf("Success reading RT\n");
  
	printf("Linhas: %d\n", rt.entry_count);
	printf("\tdest\t\tmask\t\tgw\tmetric\tif\n"); 
	line = rt.lines;
    while (line != NULL) {
		dest.s_addr = line->dest;
		strcpy(s_dest,inet_ntoa(dest));
		mask.s_addr = line->mask;
		strcpy(s_mask,inet_ntoa(mask));
		gw.s_addr = line->gw;
		strcpy(s_gw,inet_ntoa(gw));
		printf("%14s\t%14s\t%14s\t%3d\t%4s\n",s_dest,s_mask,s_gw,line->metric,line->device);
		line = line->next;
	  }
  }
  
  if (PICAdelRoute(inet_addr("192.168.0.33"),inet_addr("255.255.255.255"),inet_addr("158.42.55.147"),devs.dev_names[i])) printf("Success removing route\n");
  else 
  {
	if(PICAgetLastError(buf,&code)) printf("Error reading RT: %s\n",buf);
	else printf("error debugging\n");  
}
if (PICAdelRoute(inet_addr("10.10.10.0"),inet_addr("255.255.255.0"),inet_addr("158.42.55.250"),devs.dev_names[i])) printf("Success removing route\n");
  else 
  {
	if(PICAgetLastError(buf,&code)) printf("Error reading RT: %s\n",buf);
	else printf("error debugging\n");  
}

  }

}
//--------------------------------- M A I N ----------------------------------------------------
int main (void) {

PICAsocket mysock;
 int adm;

 //Library startup is very important !!!!
  if (!PICAstartup(0)) printf("Error starting library\n");
  else printf("PICA library initialized!\n\n");


  if (!PICAcreateSocket(&mysock,PF_INET, SOCK_DGRAM, 0, 5)) printf("Error creating socket\n");
  else printf("socket created\n");
  if (!PICAcloseSocket(mysock)) printf("Error closing socket\n");
  else printf("Socket closed\n");

   if (!PICAisAdministrator(&adm)) printf("Error getting ADM. data\n");
   else printf("Success getting ADM. data: user is %s\n",adm>0?"Administrator":"not Administrator");

   
test_devices();
   test_rtable();
}