#include <stdio.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <unistd.h>

#include <PICA/pica.h>

#define DST "192.168.3.0"
#define MSK "255.255.255.0"
#define GW "192.168.0.1"
#define DEV "eth1"

int main(void) {
 RTInfo rt;
  RTLines * line;
  struct in_addr dest,mask,gw;


  if (PICAaddRoute(inet_addr(DST),inet_addr(MSK),inet_addr(GW),5,DEV)) printf("Sucess adding route\n");
  else printf("Error adding route\n");


  //  if (CALgetRoutingTable(& rt)) printf("Success reading RT\n");
  // else printf("Error reading RT\n");

 if (PICAgetRoutingTable(& rt)) printf("Success reading RT\n");
  else printf("Error reading RT\n");


  printf("Linhas: %d\n", rt.entry_count);
  printf("\tdest\t\tmask\t\tgw\tmetric\tif\n");
  line = rt.lines;
  while (line != NULL) {
    dest.s_addr = line->dest;
    mask.s_addr = line->mask;
    gw.s_addr = line->gw;
    printf("%14s\t",inet_ntoa(dest));
    printf("%14s\t",inet_ntoa(mask));
    printf("%14s\t%3d\t%4s\n",inet_ntoa(gw),line->metric,line->device);


  line = line->next;
  }

  if (PICAdelRoute(inet_addr(DST),inet_addr(MSK),inet_addr(GW),DEV)) printf("Success removing route\n");
  else printf("Error removing route\n");
}
