#include "PICA/pica.h"
#include <sched.h>
#include <stdio.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <unistd.h>
#include <stdlib.h>


//globals

PICAmutex mymut;
PICAsemaphore mysem;


//----------------------------------  F O R W A R D I N G    T E S T -----------------------------------------------------------------
void test_forwarding(void) {
  	
	int true_false;

  printf("\n------------------ Forwarding test -----------------\n");
	
  if (!PICAisForwarding(&true_false)) printf("Error getting forwarding state\n");
  else printf("Forwarding is %s\n",true_false>0?"ON":"OFF");
  
  if (!PICAsetForwarding(FWD_ON)) printf("Error stopping forwarding\n");
  else {
	if (!PICAisForwarding(&true_false)) printf("Error getting forwarding state\n");
  else printf("Forwarding is %s\n",true_false>0?"ON":"OFF");
  
  }

  if (!PICAsetForwarding(FWD_OFF)) printf("Error starting forwarding\n");
  else {
	if (!PICAisForwarding(&true_false)) printf("Error getting forwarding state\n");
	else printf("Forwarding is %s\n",true_false>0?"ON":"OFF");
  
  }
  
}

//--------------------------------- M A I N ----------------------------------------------------
int main (void) {

PICAsocket mysock;
 int adm;

 //Library startup is very important !!!!
  if (!PICAstartup(0)) printf("Error starting library\n");
  else printf("PICA library initialized!\n\n");


  if (!PICAcreateSocket(&mysock,PF_INET, SOCK_DGRAM, 0)) printf("Error creating socket\n");
  else printf("socket created\n");
  if (!PICAcloseSocket(mysock)) printf("Error closing socket\n");
  else printf("Socket closed\n");

   if (!PICAisAdministrator(&adm)) printf("Error getting ADM. data\n");
   else printf("Success getting ADM. data: user is %s\n",adm>0?"Administrator":"not Administrator");

   

   test_forwarding();
}