/*****************************************************************************
 *
 * Copyright (C) 2002 Polytechnic University of Valencia.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Authors: Carlos Calafate, <calafate@disca.upv.es>
 *
 *****************************************************************************/

#ifndef _TIMER_H
#define _TIMER_H

#include <unistd.h> 
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/time.h> 
#include <pthread.h> 
#include <semaphore.h> 
#include <signal.h>   
#include <errno.h>   
#include <stdlib.h>   

#include "PICAspec.h"

typedef u_int64_t UINT64;

#define T_SET 0
#define T_STOP 1
#define T_STARTUP 2
#define T_KILL 3


//#define TIME_DIV 100
#define TIME_DIV 10


UINT64 PICAgetCurrTime(void);
//int PICAtimer(int action, UINT64 * time, void * function, void * data);
int PICAtimer(int action, UINT64 * time, void (*function)(void *), void * data);

/* prio queue entry */
struct prioqent
{
  UINT64 tv;  /* Time the event should happend in ms since 1 jan 1970 */
  void (*callback)(void *);
  void *data;    /* Data stored in the entry */
  struct prioqent *pqe;  /* A pointer to the next entry in the list */
};
 
/* The prio queue */
struct prioq
{
  struct prioqent *pqe;  /* Pointer to the first entry */

};


 
 
struct prioqent * pq_getfromqueue(UINT64 * time,void * function);

void pq_cleanup(void);

int pq_insert(UINT64 msec,void (*func)(void *),void * data);
 
void pq_signal(int signal);
 
void pq_updatetimer();

struct prioqent *pq_getfirst();

void pq_deleteent(struct prioqent *pqed);

void pq_unqueuefirstent();

void pq_deletefirstent();

struct prioqent *pq_getfirstdue(UINT64 tv);

#endif
