/*****************************************************************************
 *
 * Copyright (C) 2002 Polytechnic University of Valencia.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Authors: Carlos Calafate, <calafate@disca.upv.es>
 *
 *****************************************************************************/

#include "sock.h"

int PICAcreateSocket(PICAsocket * sd, int domain, int type, int protocol, int block) {

  if (sd == NULL) {
    P_ERROR("PICAcreateSocket: socket pointer is NULL", 50101);
    return 0;
  }
  
  
  
  if ((*sd = socket(domain, type, protocol)) < 0) {
    P_ERROR("PICAcreateSocket: Unable to create socket", 50102);
    return 0;
  }
  
  //----------------------aggiunto
  if(block==NO_BLOCK)
  {
	  if (fcntl(*sd, F_SETFL, O_NONBLOCK) == -1) 
	{
		P_ERROR("PICAcreateSocket: Unable to set socket blocking", 50103);
		return 0;
	}
}

//-------------------------------------
  
  return 1;
}

int PICAcloseSocket(PICAsocket sd) {

  if (close(sd) != 0) {
    P_ERROR("PICAcreateSocket: Error closing socket", 50201);
    return 0;
  }

  return 1;
}
