/*****************************************************************************
 *
 * Copyright (C) 2002 Polytechnic University of Valencia.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Authors: Carlos Calafate, <calafate@disca.upv.es>
 *
 *****************************************************************************/

#include "rtmanager.h"
#include <errno.h>


int PICAaddRoute(UINT32 dest, UINT32 mask, UINT32 gateway,int metric, char * device) {
  struct rtentry currEntry;
  int sd = 0;
  struct sockaddr_in dst;
  struct sockaddr_in genmask;
  struct sockaddr_in gw;
  int result;

  /* Get socket for UDP or TCP */
  if ((sd = socket(AF_INET, SOCK_DGRAM, 0)) < 0) {
    P_ERROR("PICAaddRoute: Unable to create socket",20101);
    return 20101; /* Unable to create socket */
  }

  bzero(&currEntry, sizeof(struct rtentry));
  bzero(&dst, sizeof(struct sockaddr_in));
  bzero(&genmask, sizeof(struct sockaddr_in));
  bzero(&gw, sizeof(struct sockaddr_in));

  dst.sin_family = AF_INET;
  genmask.sin_family = AF_INET;
  gw.sin_family = AF_INET;

  dst.sin_addr.s_addr = dest;
  genmask.sin_addr.s_addr = mask;
  gw.sin_addr.s_addr = gateway;

  currEntry.rt_flags = 0;

  if (gateway == 0xFFFFFFFF) currEntry.rt_flags = RTF_UP | RTF_HOST | RTF_GATEWAY;
  else if (gateway != 0x00000000) {
      if (mask == 0xFFFFFFFF)  currEntry.rt_flags = RTF_UP | RTF_HOST | RTF_GATEWAY;
      else currEntry.rt_flags = RTF_UP | RTF_GATEWAY;
  }
  else currEntry.rt_flags =  RTF_UP;
	  
  currEntry.rt_metric = metric+1; //seems to auto-subtract 1
  currEntry.rt_dev = device;
  currEntry.rt_dst = *(struct sockaddr*) &dst;
  currEntry.rt_gateway = *(struct sockaddr*) &gw;
  currEntry.rt_genmask = *(struct sockaddr*) &genmask;

  result=ioctl(sd, SIOCADDRT, (char *) &currEntry);
  if(result != 0 && errno!=EEXIST)
  {
	P_ERROR("PICAaddRoute: Unable to add route entry",20102);
	return 0;
  }
  
/*	  
if(ioctl(sd, SIOCADDRT, (char *) &currEntry) != 0) {
    // SIOCADDRT failed 
    P_ERROR("PICAaddRoute: Unable to add route entry",20102);
    return 0;
  }*/
/*err=  ioctl(sd, SIOCADDRT, (char *) &currEntry);
  if(err!= 0) {
    /* SIOCADDRT failed 
    P_ERROR("PICAaddRoute: Unable to add route entry",errno);
    return 0;
  }*/
  return 1;
}


int PICAdelRoute(UINT32 dest, UINT32 mask, UINT32 gateway, char * device) {
 struct rtentry currEntry;
  int sd = 0;
  struct sockaddr_in dst;
  struct sockaddr_in genmask;
  struct sockaddr_in gw;
 int result;

  /* Get socket for UDP or TCP */
  if ((sd = socket(AF_INET, SOCK_DGRAM, 0)) < 0) {
    P_ERROR("PICAdelRoute: Unable to create socket",20201);
    return 0; /* Unable to create socket */
  }

  bzero(&currEntry, sizeof(struct rtentry));
  bzero(&dst, sizeof(struct sockaddr_in));
  bzero(&genmask, sizeof(struct sockaddr_in));
  bzero(&gw, sizeof(struct sockaddr_in));

  dst.sin_family = AF_INET;
  genmask.sin_family = AF_INET;
  gw.sin_family = AF_INET;

  dst.sin_addr.s_addr = dest;
  genmask.sin_addr.s_addr = mask;
  gw.sin_addr.s_addr = gateway;

  currEntry.rt_dev = device;
  currEntry.rt_dst = *(struct sockaddr*) &dst;
  currEntry.rt_genmask = *(struct sockaddr*) &genmask;
  currEntry.rt_gateway = *(struct sockaddr*) &gw;

  result=ioctl(sd, SIOCDELRT, (char *) &currEntry);
  if(result!=0 && errno!=ESRCH)
  {
	P_ERROR("PICAdelRoute: Unable to remove route entry",20202);
	/* SIOCDELRT failed */ 
	return 0;
}
  
 /* if(ioctl(sd, SIOCDELRT, (char *) &currEntry) != 0) {
    P_ERROR("PICAdelRoute: Unable to remove route entry",20202);
    // SIOCDELRT failed *
    return 0;
  }*/

  return 1;
}

/* //seems to return old entries that were already removed
int PICAgetRoutingTable_old(RTInfo * rti) {
  
  FILE *  fd;
  char line[300];
  int flags,refcnt,use,mtu,window,irtt;
  int  init = 0;
  RTLines * newLine, * oldLine;
  
  bzero(rti,sizeof(RTInfo));
  
  if ((fd = fopen("/proc/net/route","r")) == NULL) {
    return 0;
  }
  if (fgets(line, 299, fd) == NULL) {
    fclose(fd);
    return 0;
  }

  while (fgets(line, 299, fd) != NULL) {

    newLine = (RTLines *) malloc(sizeof(RTLines));
 

    newLine->device = (char *) malloc(20);
    sscanf(line,"%s\t%X\t%X\t%X\t%d\t%d\t%d\t%X\t%d\t%d\t%d\t",newLine->device,& (newLine->dest),&(newLine->gw),&flags,&refcnt,&use,&(newLine->metric),&(newLine->mask),&mtu,&window,&irtt);
    newLine->next = NULL;
    if (!init) {
      rti->lines = newLine; //saves first line address
      init = 1;
    } else {
      oldLine->next = newLine;
    }
    rti->entry_count++;
    oldLine = newLine;

  }
  fclose(fd);
  return 1;
}
*/


int PICAgetRoutingTable(RTInfo * rti) {
 
  FILE *  fd;
  char line[300];
  char dest[16], gw[16], mask[16], flags[6];
  int ref,use;
  int  init = 0;
  RTLines * newLine, * oldLine;
  struct in_addr ip_reader;
  
  if ((fd = popen("route -n","r")) == NULL) {
    P_ERROR("PICAgetRoutingTable: Unable to call route system call",20301);
    return 0;
  }
  
  if (fgets(line, 299, fd) == NULL) {
    P_ERROR("PICAgetRoutingTable: No enough data from route",20302);
    return 0;
  }
  
  if (fgets(line, 299, fd) == NULL) {
    P_ERROR("PICAgetRoutingTable: No enough data from route",20303);
    return 0;
  }
  
  while (fgets(line, 299, fd) != NULL) {
    
    if ((newLine = (RTLines *) malloc(sizeof(RTLines))) == NULL) {
      P_ERROR("PICAgetRoutingTable: unable to allocate memory",20304);
      return 0;
    }
    
    if ((newLine->device = (char *) malloc(20)) == NULL) {
      P_ERROR("PICAgetRoutingTable: unable to allocate memory",20305);
      return 0;
   }
    
    //   printf("line is: %s\n",line);
    
   if (sscanf(line,"%s\t%s\t%s\t%s\t%d\t%d\t%d\t%s",dest, gw, mask, flags, &(newLine->metric),&ref, &use, newLine->device) <= 0) {
     P_ERROR("PICAgetRoutingTable: error reading routing table data",20306);
     return 0;
   }
   
   // printf("rtmanager: dest=%s gw=%s mask=%s device=%s\n",dest,gw,mask, newLine->device);
   /*
     newLine->dest = inet_addr(dest);
     newLine->mask = inet_addr(mask);
     newLine->gw = inet_addr(gw);
   */
   
   if (inet_aton(dest, &ip_reader) == 0) {
     P_ERROR("PICAgetRoutingTable: unable to convert entry to IP address",20307);
     return 0;
   }
   newLine->dest = ip_reader.s_addr;
   if (inet_aton(mask, &ip_reader) == 0)   {
     P_ERROR("PICAgetRoutingTable: unable to convert entry to IP address",20308);
     return 0;
   }
   newLine->mask = ip_reader.s_addr;
   if (inet_aton(gw,&ip_reader) == 0) {
     P_ERROR("PICAgetRoutingTable: unable to convert entry to IP address",20309);
     return 0;
   }
   newLine->gw = ip_reader.s_addr;
   
   
   newLine->next = NULL;
   if (!init) {
     rti->lines = newLine; //saves first line address
     init = 1;
   } else {
     oldLine->next = newLine;
   }
   rti->entry_count++;
   oldLine = newLine;
   
  }

  if (pclose(fd) == -1)  {
    P_ERROR("PICAgetRoutingTable: error closing route process",20310);
    return 0;
  }
  
  return 1;
}
