/*****************************************************************************
 *
 * Copyright (C) 2002 Polytechnic University of Valencia.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Authors: Carlos Calafate, <calafate@disca.upv.es>
 *
 *****************************************************************************/

#include "packet.h"



//man packet
int PICAopenDevice(char * device, PICA_IO_DEVICE * iodev, int timeout, int mode) {
  struct ifreq ifr;
  struct sockaddr_ll ll;
  int ethsock;
  
  if ((ethsock = socket(AF_PACKET, SOCK_RAW, htons(ETH_P_ALL))) < 0) {
    P_ERROR("PICAopenDevice: Unable to create socket with AF_PACKET,SOCK_RAW", 40101);
    return 0;
  }
  
    //set promiscuos or not promiscuos mode
 /* if(mode==PROMISCUOUS)
  {
	  if(ioctl(ethsock, SIOCGIFFLAGS, (void *) &ifr) < 0 ) {
	    P_ERROR("PICAopenDevice: Unable set promiscuous mode", 40103);
	    return 0;
	  }
	  ifr.ifr_flags |= IFF_PROMISC;
	  ioctl(ethsock, SIOCSIFFLAGS, &ifr);
  }*/
  //----end set promiscuos mode
  
  memset(&ifr, 0, sizeof(ifr));
  strncpy(ifr.ifr_name, device, IFNAMSIZ);
  
  if(ioctl(ethsock, SIOCGIFINDEX, (void *) &ifr) < 0 ) {
    P_ERROR("PICAopenDevice: Unable get interface index", 40102);
    return 0;
  }
  
  
  ll.sll_family = AF_PACKET;
  ll.sll_protocol = 0;//htons(ethtype);
  ll.sll_ifindex = ifr.ifr_ifindex;
  
  if (bind(ethsock, (struct sockaddr*) &ll, sizeof(ll)) < 0) {
    P_ERROR("PICAopenDevice: Unable to bind socket to specified device", 40103);
    return 0;
  }
  
  *iodev = ethsock;
   
  return 1;
}


int PICAframe(int mode, PICA_IO_DEVICE iodev, void * packet, int packetsize, int * datasize) {
     
    if (packet == NULL) {
      P_ERROR("PICAframe: packet points to NULL", 40201);
      return 0;
    }
    if (packetsize <=0) {
      P_ERROR("PICAframe: packetsize is must be grater than  0", 40202);
      return 0;
    }
    if (datasize == NULL) {
      P_ERROR("PICAframe: datasize points to NULL", 40203);
      return 0;
    }
    

    if (mode == PICA_SEND) {
      if ((*datasize = write(iodev, packet, packetsize)) == -1) {
	P_ERROR("PICAframe: Error writing to interface", 40204);
	return 0;
      }
    }

    else if (mode == PICA_RECEIVE) {
      if ((*datasize = read(iodev, packet, packetsize)) == -1) {
	P_ERROR("PICAframe: Error reading from interface", 40205);
	return 0;
      }
    
    } else {
      P_ERROR("PICAframe: Invalid user mode.", 40206);
      return 0;
    }
    
    return 1;
}

int PICAcloseDevice(PICA_IO_DEVICE iodev) {
  
  if (close(iodev) == -1) {
    P_ERROR("PICAcloseDevice: Error closing device", 40301);
    return 0;
  }

  return 1;
}

int PICAcreatePacket(char *addr, unsigned char *data, int datasize, unsigned char * packet, int * packetsize)
{
	int i=0, j=0,k;
	unsigned char addr_aux[2];


	if(addr==NULL)
	{
		P_ERROR("PICAcreatepacket: parameter addr is null",40401);
		return 0;
	}
	
	if(data==NULL)
	{
		P_ERROR("PICAcreatepacket: parameter data is null",40401);
		return 0;
	}

	if(packet==NULL)
	{
		P_ERROR("PICAcreatepacket: parameter packet is null",40401);
		return 0;
	}

	if(packetsize==NULL)
	{
		P_ERROR("PICAcreatepacket: parameter packetsize is null",40401);
		return 0;
	}

	if(datasize < 46)
	{
		P_ERROR("PICAcreatepacket: datasize is too small",40401);
		return 0;
	}

	
	

//check address
	if(addr[2]==':' && addr[5]==':' && addr[8]==':' && addr[11]==':' && addr[14]==':')
	{
	//ZeroMemory(&addr_aux[0],2);
	while(i<17)
	{
		for(k=i; k<=i+1;k++)
		{

			if(addr[k]>= '0' && addr[k]<= '9')
			{
				addr_aux[k-i]=addr[k]-'0';

			}
			else if (addr[k]>= 'A' && addr[k]<= 'F')
			{
				addr_aux[k-i]=addr[k]-'A' + 10;
			}
			else if (addr[k]>= 'a' && addr[k]<= 'f')
			{
				addr_aux[k-i]=addr[k]-'a'+10;
			}
			else 
			{
				P_ERROR("PICAcreatepacket: bad format address number 0-9 digit a-f or A-F",40401);
				return 0;
			}
		}//fine for su k
		packet[j]= (addr_aux[0] << 4) | addr_aux[1] ;
		//printf("buf %d: %x\n", j, buf[j]);
		i+=3;
		j++;
	}
	}
	else 
	{
		P_ERROR("PICAcreatepacket:bad format address!!! use ':' \n", 40402);
		return 0;
	}

//dal 6 al 13 non si tocca
//fare la copia dei dati da data a buf[14]
//type or length
packet[12]=data[0];
packet[13]=data[1];
//controllare che la dim dei dat sia > 46 llora usare quella li se no usare 46 ok

	memcpy(&packet[14], &data[2], datasize);
	*packetsize=datasize+14;


	
	
	return 1;
}
