/*****************************************************************************
 *
 * Copyright (C) 2002 Polytechnic University of Valencia.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Authors: Carlos Calafate, <calafate@disca.upv.es>
 *
 *****************************************************************************/

#ifndef _MEM_H
#define _MEM_H

#include <pthread.h> 
#include <stdlib.h> 
#include <string.h>  
#include <unistd.h>

#include "PICAspec.h"

typedef struct _PICApacket {
  int packet_size;
  void * data;
  struct _PICApacket * next;
} PICApacket;

typedef struct _PICAbuffer {
  int tot_queues;
  pthread_mutex_t * buf_mut;
  struct _PICApacket ** packet_queues;
} PICAbuffer;

typedef int PICApipe;

int PICAinitBuffer(PICAbuffer ** ibuf, int num_queues);

int PICAaddToBuffer(PICAbuffer * buf, int queue_id, void * data, int data_size);

int PICAgetFromBuffer(PICAbuffer * buf, int queue_id, int num_packets, PICApacket ** packets, int * avail_packets);

int PICAkillBuffer(PICAbuffer * buf);
 
int PICAmakePipe(PICApipe * in, PICApipe * out);
 
int PICAsendToPipe(PICApipe out, void * data, int size, int * written);
 
int PICAgetFromPipe(PICApipe in, void * buf, int bufsize, int * datasize);
 
int PICAclosePipe(PICApipe pipe);

#endif
