/*****************************************************************************
 *
 * Copyright (C) 2002 Polytechnic University of Valencia.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Authors: Carlos Calafate, <calafate@disca.upv.es>
 *
 *****************************************************************************/

#include "log.h"


int PICAopenFile(FDesc * fdesc, char * name,int read_write, int flags) {
  
  if (fdesc == NULL) {
    P_ERROR("PICAopenFile: file descriptor points to NULL", 90101);
    return 0;
  }

  if (name == NULL) {
    P_ERROR("PICAopenFile: file name points to NULL", 90102);
    return 0;
  }

  if (read_write == READF) {
    
    if ((*fdesc = open(name,O_RDONLY)) == -1) {
      P_ERROR("PICAopenFile: error opening file", 90103);
      return 0;
    } else return 1;
    
  } else if (read_write == WRITEF){
    
    if (flags == CREATE_CLEAN) {
      if ((*fdesc = open(name,O_CREAT | O_WRONLY | O_TRUNC,S_IRUSR|S_IWUSR)) == -1) {
	P_ERROR("PICAopenFile: error opening file", 90104);
	return 0;
      } else return 1;
      
    } else if (flags == APPEND) {
      if ((*fdesc =  open(name,O_CREAT | O_WRONLY | O_APPEND,S_IRUSR|S_IWUSR)) == -1) {
	P_ERROR("PICAopenFile: error opening file", 90105);
	return 0;
      } else return 1;
    } else {
      P_ERROR("PICAopenFile: unknown value for flags", 90106);
      return 0;
    }
    
  } else if (read_write == READF_WRITEF) {
    
    if (flags == CREATE_CLEAN) {
      if ((*fdesc = open(name,O_CREAT | O_RDWR | O_TRUNC,S_IRUSR|S_IWUSR)) == -1) {
	P_ERROR("PICAopenFile: error opening file", 90107);
	return 0;
      } else return 1;
	  
    } else if (flags == APPEND) {
      if ((*fdesc = open(name,O_CREAT | O_RDWR | O_APPEND,S_IRUSR|S_IWUSR)) == -1) {
	P_ERROR("PICAopenFile: error opening file", 90108);
	return 0;
      } else return 1;
    } else {
      P_ERROR("PICAopenFile: unknown value for flags", 90109);
      return 0;
    }
    
  } else {
    P_ERROR("PICAopenFile: unknown read/write mode", 90110);
    return 0;
  }
  
  return 1;
  
}


int PICAwriteToFile(FDesc file, void * data, unsigned int datasize) {
  int escr, total_written, remain;
  char * curr_pos;
  

  if (data == NULL) {
    P_ERROR("PICAwriteToFile: data points to NULL", 90201);
    return 0;
  }
  
  if (datasize < 1) {
    P_ERROR("PICAwriteToFile: invalid data size", 90202);
    return 0;
  }
  
  total_written = 0;	
  curr_pos = (char *) data;
  remain = datasize;

  do {		
    if ((escr = write(file,(void *) curr_pos,remain)) == -1) {
      P_ERROR("PICAwriteToFile: error writing file", 90203);
      return 0;		
  }
    total_written += escr;
    curr_pos += escr;
    remain -=escr;
  } while (total_written != datasize);
  
  return 1;
}

int PICAreadFile(FDesc file, void * buf, int buffersize, int * datasize) {

  
  if (buf == NULL) {
    P_ERROR("PICAreadFile: buffer points to NULL", 90301);
    return 0;
  }
  if (datasize == NULL) {
    P_ERROR("PICAreadFile: datasize points to NULL", 90302);
    return 0;
  }
 
  if (buffersize < 1) {
    P_ERROR("PICAreadFile: invalid array size", 90303);
    return 0;
  }
  
  if ((*datasize = read(file, buf, buffersize)) == -1) {
   P_ERROR("PICAreadFile: error reading file", 90304);
   return 0;
  }
 
 return 1;

}


int PICAcloseFile(FDesc file) {
  
  if(close(file) == -1) {
    P_ERROR("PICAcloseFile: error closing file", 90401);
    return 0;
  }

  return 1;
}

int PICAgetTimeStr(char ** time_str) {
    struct timeval curr_time;

    
    if (gettimeofday(&curr_time, (struct timezone *)NULL) == -1) {
	P_ERROR("PICAgetTimeStr: error in gettimeofday()", 90501);
	return 0;
    }
    if ((*time_str = ctime((time_t *)&curr_time.tv_sec)) == NULL) {
	P_ERROR("PICAgetTimeStr: error in ctime()", 90502);
	return 0;
    }
    
    (*time_str)[strlen(*time_str)-1] = '\0';

    return 1;
}




 
