/*****************************************************************************
 *
 * Copyright (C) 2002 Polytechnic University of Valencia.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Authors: Carlos Calafate, <calafate@disca.upv.es>
 *
 *****************************************************************************/

#include "ipfwd.h"

int PICAisForwarding(int * true_false) {
  int fd;
  char val;

  if (true_false == NULL)  {
    P_ERROR("PICAisForwarding: true_false is NULL", 30101);
    return 0;
  }
  
  if ((fd = open("/proc/sys/net/ipv4/ip_forward",O_RDONLY)) == -1) {
    P_ERROR("PICAisForwarding: Unable to open file: /proc/sys/net/ipv4/ip_forward", 30102);
    return 0;
  }

  if (read(fd,&val,1) <1) {
    P_ERROR("PICAisForwarding: Unable to read file: /proc/sys/net/ipv4/ip_forward", 30103);
    close(fd);
    return 0;
  }

  if (val == '1') *true_false = 1;
  else if (val == '0') *true_false = 0;
  else {
    P_ERROR("PICAisForwarding: Invalid value for forwarding state", 30103);
    close(fd);
    return 0;
  }
  
  if (close(fd) == -1) {
    P_ERROR("PICAisForwarding: Error closing file desciptor", 30104);
    return 0;
  }
  
  return 1;

}


int PICAsetForwarding(int on_off) {
  int fd;
 
  char state = '1';
 
  if (on_off == 0) state = '0';
  else if (on_off != 1) {
    P_ERROR("PICAsetForwarding: Invalid user value for forwarding state", 30201);
    return 0;
  }


  if ((fd = open("/proc/sys/net/ipv4/ip_forward", O_WRONLY)) == -1){
    P_ERROR("PICAsetForwarding: Unable to open file: /proc/sys/net/ipv4/ip_forward", 30202);
    return 0;
  }
  
  if (write(fd,&state,sizeof(state)) == -1){
    P_ERROR("PICAsetForwarding: Unable to write to file: /proc/sys/net/ipv4/ip_forward", 30203);
    close(fd);
    return 0;
  }
  
  if (close(fd) == -1) {
    P_ERROR("PICAsetForwarding: Error closing file desciptor", 30204);
    return 0;
  }

  return 1;
  
}

int PICAdefaultTTL(int set_get, int * ttl) {
  int fd;
  
  char ttl_val[4];

  if (ttl == NULL) {
    P_ERROR("PICAdefaultTTL: ttl variable is NULL", 30301);
    return 0;
  }
  
  if (*ttl < 0 || *ttl > 255) {
    P_ERROR("PICAdefaultTTL: Invalid user value for system TTL", 30302);
    return 0;
  }
  
  
  
  if (set_get == TTL_SET) {
    
    if ((fd = open("/proc/sys/net/ipv4/ip_default_ttl", O_WRONLY)) == -1) {
      P_ERROR("PICAdefaultTTL: Unable to open file: /proc/sys/net/ipv4/ip_default_ttl", 30303);
      return 0;
    }
    
    sprintf(ttl_val,"%d",*ttl);
    
    if (write(fd,ttl_val,strlen(ttl_val)) == -1){
      P_ERROR("PICAdefaultTTL: Unable to write to file: /proc/sys/net/ipv4/ip_default_ttl", 30303);
      close(fd);
      return 0;
    }
    
    
  } else if (set_get == TTL_GET) {
    if ((fd = open("/proc/sys/net/ipv4/ip_default_ttl", O_RDONLY)) == -1) {
      P_ERROR("PICAdefaultTTL: Unable to open file: /proc/sys/net/ipv4/ip_default_ttl", 30304);
      return 0;
    }
    
    
    if (read(fd,ttl_val,3) < 1){
      P_ERROR("PICAdefaultTTL: Unable to read from file: /proc/sys/net/ipv4/ip_default_ttl", 30305);
      close(fd);
      return 0;
    }

    sscanf(ttl_val,"%d",ttl);

  } else {
    P_ERROR("PICAdefaultTTL: Invalid user action", 30306);
    return 0;
  }
  
  if (close(fd) == -1) {
    P_ERROR("PICAdefaultTTL: Error closing file descriptor", 30307);
    return 0;
  }

  return 1;
}
