/*****************************************************************************
 *
 * Copyright (C) 2002 Polytechnic University of Valencia.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Authors: Carlos Calafate, <calafate@disca.upv.es>
 *
 *****************************************************************************/

#include "devs.h"

int PICAgetAvailableDevices(DEVLIST * devs) {

    int sock;
    struct ifconf ifc;
    struct ifreq *ifr;
    char buf[BUFSIZ], *cp, *cplim; 
    int curr_dev = 0;

  if ((sock = socket(AF_INET, SOCK_DGRAM, 0)) == -1) {
      P_ERROR("PICAgetAvailableDevices: Unable to create socket with AF_PACKET,SOCK_DGRAM", 10201);
      return 0;      
  }

        ifc.ifc_len = sizeof (buf);
        ifc.ifc_buf = buf;
        if (ioctl(sock, SIOCGIFCONF, (char *)&ifc) < 0) { 
	    P_ERROR("PICAgetAvailableDevices: Unable to get available devices", 10202);
	    close(sock);
            return 0;
        }

        ifr = ifc.ifc_req;

        cplim = buf + ifc.ifc_len; 
        for (cp = buf; cp < cplim; cp += sizeof (ifr->ifr_name) + sizeof(ifr->ifr_addr)) {
                ifr = (struct ifreq *)cp;
		strcpy(devs->dev_names[curr_dev],ifr->ifr_name);
		curr_dev++;
	}    

  devs->num_devices = curr_dev;
  close(sock);

  return 1;
}



int PICAgetDeviceAttrs(char * dev, DevAttrs * attrs) {
  
  int ethsock;
  struct ifreq ifr; 
  struct sockaddr_in sin;


  if ((ethsock = socket(AF_PACKET, SOCK_DGRAM, 0)) == -1) {
    P_ERROR("PICAgetDeviceAttrs: Unable to create socket with AF_PACKET,SOCK_DGRAM", 10201);
    return 10201;
  }

  memset(&ifr, 0, sizeof(ifr));
  strncpy(ifr.ifr_name, dev, IFNAMSIZ);

  if(ioctl(ethsock, SIOCGIFHWADDR, (void *) &ifr) < 0 ) {
    P_ERROR("PICAgetDeviceAttrs: Error getting hardware (MAC) address", 10202);
    close(ethsock);
    return 10202;
  }
  memcpy(attrs->ha, &(ifr.ifr_hwaddr.sa_data[2]), 6);

  if (ioctl(ethsock, SIOCGIFADDR,(void *) &ifr) < 0) {
    P_ERROR("PICAgetDeviceAttrs: Error getting IP address", 10203);
    close(ethsock);
    return 10203;
  }
  
  memcpy(&sin, (struct sockaddr_in *)(&ifr.ifr_addr), sizeof(struct sockaddr_in));
  
  attrs->ip_addr = sin.sin_addr.s_addr;
  

  if (ioctl(ethsock, SIOCGIFNETMASK, (char *)&ifr) < 0) {
      P_ERROR("PICAgetDeviceAttrs: Error getting Net mask", 10204);
      close(ethsock);
      return 10204;          
  }

  memcpy(&sin, (struct sockaddr_in *)(&ifr.ifr_addr), sizeof(struct sockaddr_in));
  
  attrs->mask = sin.sin_addr.s_addr;

  if (ioctl(ethsock, SIOCGIFINDEX, (char *)&ifr) < 0) {
      P_ERROR("PICAgetDeviceAttrs: Error getting interface index", 10205);
      close(ethsock);
      return 10205;  
  }

  attrs->index = ifr.ifr_ifindex;

  close(ethsock);
  return 1;
}
