/*****************************************************************************
 *
 * Copyright (C) 2002 Polytechnic University of Valencia.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Authors: Carlos Calafate, <calafate@disca.upv.es>
 *
 *****************************************************************************/

#include "PICAspec.h"

extern pthread_mutex_t timermutex;
extern sem_t * timersem;

pthread_mutex_t errormutex = PTHREAD_MUTEX_INITIALIZER;

static char errbuf[PICA_ERR_BUF_SIZE] = "";
static int err_code = 0;

int PICAstartup(int flags) { 
 
  strcpy(errbuf,"");
  err_code = 0;

  if ((timersem = malloc(sizeof(sem_t))) == NULL) {
    P_ERROR("PICAstartup: unable to allocate memory", 110101);
    return 0;
  }

  return 1;
}

int PICAcleanup(void) { 
  
  free(timersem);
  return 1;
}
 

int PICAgetLastError(char * err, int * code) {
  
  if (err == NULL) {
    P_ERROR("PICAgetLastError: error buffer points to NULL", 110201);
    return 0;
  } 

  if (code == NULL) {
    P_ERROR("PICAgetLastError: code points to NULL", 110202);
    return 0;
  }

  pthread_mutex_lock(&errormutex);
  strcpy(err, errbuf);
  *code = err_code;
  strcpy(errbuf,"");
  err_code = 0;
  pthread_mutex_unlock(&errormutex);
  return 1;
}

void P_ERROR(char * message, int code) {
  pthread_mutex_lock(&errormutex);
  if (strlen(message) >98) strcpy(errbuf,"PICA's buffer size for error was too small");
  else strcpy(errbuf,message);
  err_code = code;
  pthread_mutex_unlock(&errormutex);
}
