/*****************************************************************************
 *
 * Copyright (C) 2002 Polytechnic University of Valencia.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Authors: Carlos Calafate, <calafate@disca.upv.es>
 *
 *****************************************************************************/


#include "packet.h"


int PICAopenDevice(char * device, PICA_IO_DEVICE * iodev) {
unsigned short * wdevice;
int size;

	if (device == NULL) {
		P_ERROR("PICAopenDevice: device points to NULL", 40101);
		return 0;
	} else {
		size = sizeof(unsigned short) * strlen(device);
		wdevice= (unsigned short *) malloc(size);	
		MultiByteToWideChar(CP_ACP,MB_PRECOMPOSED,device,-1,wdevice,size);
	}

	if (iodev == NULL) {
		P_ERROR("PICAopenDevice: iodev points to NULL", 40102);
		free(wdevice);
		return 0;
	}

/*	if (*iodev == NULL) {
		P_ERROR("PICAopenDevice: iodev is NULL", 40103);
		return 0;
	}
*/
	
	if ((*iodev = PacketOpenAdapter(wdevice)) == NULL || ((*iodev)->hFile == INVALID_HANDLE_VALUE)) {
		P_ERROR("PICAopenDevice: Error while trying to open adapter", 40105);
		free(wdevice);
		return 0;
	} else {
		free(wdevice);
	}

	
	if(PacketSetHwFilter(*iodev,NDIS_PACKET_TYPE_PROMISCUOUS)==FALSE){			
		P_ERROR("PICAopenDevice: Error setting promiscuous mode", 40106);		
		return 0;	
	}	
	if(PacketSetBuff(*iodev,512*1024)==FALSE){				
		P_ERROR("PICAopenDevice: Unable to set kernel buffer size", 40107);		
		return 0;
	}

	if(PacketSetReadTimeout (*iodev, 0) == FALSE) { //wait forever
		P_ERROR("PICAopenDevice: Unable to set kernel buffer size", 40108);		
		return 0;
	}

	if(PacketSetNumWrites (*iodev, 1) == FALSE) {
		P_ERROR("PICAopenDevice: Unable to set number of bytes read before returning", 40108);		
		return 0;
	}	

	if (!PacketSetMinToCopy(*iodev,1)) {
		P_ERROR("PICAopenDevice: Error while setting minimum number of bytes to copy", 40109);	
		return 0;
	}

	return 1;
}


int PICAframe(int mode, PICA_IO_DEVICE iodev, void * packet, int packetsize, int * datasize) {
		
	PACKET pkt, * lpPacket;
	char * aux;	
	unsigned short * buffer;
	int retval = 1;
	u_int off=0;
	struct bpf_hdr *hdr;


	if (packet == NULL) {
		P_ERROR("PICAframe: packet points to NULL", 40201);
		return 0;
	}

	if (datasize == NULL) {
		P_ERROR("PICAframe: datasize points to NULL", 40202);
		return 0;
	}	


	if (mode == PICA_SEND) {			
		
		ZeroMemory( &pkt, sizeof( pkt ) );
		PacketInitPacket(&pkt, buffer, packetsize);
	
		if (!PacketSendPacket(iodev, &pkt, TRUE)) {
			P_ERROR("PICAframe: error sending packet", 40203);
			return 0;
		}
	
	} else if (mode == PICA_RECEIVE) {
		
		if ((buffer = (unsigned short *) malloc(2048)) == NULL) {
			P_ERROR("PICAframe: error allocating memory", 40204);
			return 0;
		}
		if((lpPacket = PacketAllocatePacket())==NULL){
			P_ERROR("PICAframe: error allocating packet memory", 40205);
			return 0;
		} 
	
	
		PacketInitPacket(lpPacket, buffer, 2048);
	
		do {		
			ZeroMemory( &pkt, sizeof( pkt ) );
			PacketInitPacket(&pkt, buffer, 2048);
			
			if (!PacketReceivePacket(iodev, lpPacket,TRUE)) {
				P_ERROR("PICAframe: error receiving packet", 40206);
				return 0;
			} else {
				if (lpPacket->ulBytesReceived > 0) {
					aux = (char *) lpPacket->Buffer;
			
					hdr=(struct bpf_hdr *)(buffer);
			

					if (packetsize < hdr->bh_datalen) {
						P_ERROR("PICAframe: packetsize is not big enough to contain packet", 40207);
						return 0;
					} else {
						if ((*datasize = hdr->bh_datalen) > 19) {				
							aux = &aux[hdr->bh_hdrlen];					
							memcpy((char *) packet,(char *) aux,*datasize);
						}
					}
				}
				
			}
		} while (lpPacket->ulBytesReceived < 1 || hdr->bh_datalen < 20);

		PacketFreePacket(lpPacket);
		free(buffer);

	} else {
		P_ERROR("PICAframe: unknown user option", 40208);		
		return 0;
	}

	return 1;
}



int PICAcloseDevice(PICA_IO_DEVICE iodev) {
	
	if (iodev == NULL) {
		P_ERROR("PICAcloseDevice: iodev is NULL", 40301);		
		return 0;
	}
	
	PacketCloseAdapter(iodev);

	return 1;
}