/*****************************************************************************
 *
 * Copyright (C) 2002 Polytechnic University of Valencia.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Authors: Carlos Calafate, <calafate@disca.upv.es>
 *
 *****************************************************************************/


#include "log.h"

int PICAopenFile(FDesc * file, char * name, int read_write, int flags) {
unsigned short * fname;
int size;

	if (file == NULL) {
		P_ERROR("PICAopenFile: file descriptor points to NULL", 90101);
		return 0;
	}

	if (name == NULL) {
		P_ERROR("PICAopenFile: file name points to NULL", 90102);
		return 0;
	} else {
		size = sizeof(unsigned short) * strlen(name);
		fname = (unsigned short *) malloc(size);	
		MultiByteToWideChar(CP_ACP,MB_PRECOMPOSED,name,-1,fname,size);
	}
	
	if (read_write == READF) {
		
		if ((*file = CreateFile(fname,GENERIC_READ,0,NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL)) == NULL) {
			P_ERROR("PICAopenFile: error opening file", 90103);	
			free(fname);
			return 0;		
		}

	} else if (read_write == WRITEF){
		
		if (flags == CREATE_CLEAN) {
			if ((*file = CreateFile(fname,GENERIC_WRITE,0,NULL,CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL,NULL)) == NULL) {
				P_ERROR("PICAopenFile: error opening file", 90104);	
				free(fname);
				return 0;
			}
		} else if (flags == APPEND) {
			if ((*file = CreateFile(fname,GENERIC_WRITE,0,NULL,OPEN_ALWAYS,FILE_ATTRIBUTE_NORMAL,NULL)) == NULL) {
				P_ERROR("PICAopenFile: error opening file", 90105);	
				free(fname);
				return 0;
			}
		} else {
			P_ERROR("PICAopenFile: unknown value for flags", 90106);	
			free(fname);
			return 0;
		}

	} else if (read_write == READF_WRITEF) {

		if (flags == CREATE_CLEAN) {
			if ((*file = CreateFile(fname,GENERIC_READ|GENERIC_WRITE,0,NULL,CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL,NULL)) == NULL) {
					P_ERROR("PICAopenFile: error opening file", 90107);
					free(fname);
					return 0;
			}
			
		} else if (flags == APPEND) {
			if ((*file = CreateFile(fname,GENERIC_READ|GENERIC_WRITE,0,NULL,OPEN_ALWAYS,FILE_ATTRIBUTE_NORMAL,NULL)) == NULL) {
				P_ERROR("PICAopenFile: error opening file", 90108);	
				free(fname);
				return 0;
			}
		
		} else {
			P_ERROR("PICAopenFile: unknown value for flags", 90109);
			free(fname);
			return 0;
		}

	} else {
	    P_ERROR("PICAopenFile: unknown read/write mode", 90110);	
		free(fname);
		return 0;
	}

	free(fname);
	return 1;
}


int PICAwriteToFile(FDesc file, void * data, unsigned int datasize) {
	DWORD escr, total_written, remain;
	byte * curr_pos;
	
	if (data == NULL) {
		P_ERROR("PICAwriteToFile: data points to NULL", 90201);
		return 0;
	}
  
	if (datasize < 1) {
	    P_ERROR("PICAwriteToFile: invalid data size", 90202);
		return 0;
	}


	total_written = 0;	
	curr_pos = (byte *) data;
	remain = datasize;

	do {		
		if (WriteFile(file,(void *) curr_pos,remain,&escr,NULL) == 0) {
		    P_ERROR("PICAwriteToFile: error writing file", 90203);	
			return 0;		
		}
		total_written += escr;
		curr_pos += escr;
		remain -=escr;
	} while (total_written != datasize);
	
	return 1;
}


int PICAreadFile(FDesc file, void * buf, int buffersize, int * datasize) {

	ULONG size;

	if (buf == NULL) {
		P_ERROR("PICAreadFile: buffer points to NULL", 90301);
		return 0;
	}

	if (datasize == NULL) {
		P_ERROR("PICAreadFile: datasize points to NULL", 90302);
		return 0;
	}
 
	if (buffersize < 1) {
		P_ERROR("PICAreadFile: invalid array size", 90303);
		return 0;
	}
 

	if (ReadFile(file,buf,buffersize,&size,NULL) == 0) {
		P_ERROR("PICAreadFile: error reading file", 90304);	
		return 0;
	}		
	*datasize = size;

	return 1;
}


int PICAcloseFile(FDesc file) {

	if(!CloseHandle(file)) {
	    P_ERROR("PICAcloseFile: error closing file", 90401);
		return 0;
	}

	return 1;
}


int PICAgetTimeStr(char ** time_str) {
	SYSTEMTIME st;

	if ((*time_str = (char *) malloc(128)) == NULL) {
		P_ERROR("PICAcloseFile: unable to allocate memory", 90501);
		return 0;
	}

	GetLocalTime(&st);

	switch (st.wDayOfWeek) {
		case 0: sprintf(*time_str, "Sunday ");
				break;
		case 1: sprintf(*time_str, "Monday ");
				break;
		case 2: sprintf(*time_str, "Tuesday ");
				break;
		case 3: sprintf(*time_str, "Wednesday ");
				break;
		case 4: sprintf(*time_str, "Thursday ");
				break;
		case 5: sprintf(*time_str, "Friday ");
				break;
		default : sprintf(*time_str, "Saturday ");		
	}

	switch (st.wMonth) {
		case 1: sprintf(*time_str, "%sJan %d %.2d:%2.2d:%2.2d CEST %d", *time_str,st.wDay,st.wHour,st.wMinute,st.wSecond,st.wYear);
				break;
		case 2: sprintf(*time_str, "%sFeb %d %.2d:%2.2d:%2.2d CEST %d", *time_str,st.wDay,st.wHour,st.wMinute,st.wSecond,st.wYear);
				break;
		case 3: sprintf(*time_str, "%sMar %d %.2d:%2.2d:%2.2d CEST %d", *time_str,st.wDay,st.wHour,st.wMinute,st.wSecond,st.wYear);
				break;
		case 4: sprintf(*time_str, "%sApr %d %.2d:%2.2d:%2.2d CEST %d", *time_str,st.wDay,st.wHour,st.wMinute,st.wSecond,st.wYear);
				break;
		case 5: sprintf(*time_str, "%sMay %d %.2d:%2.2d:%2.2d CEST %d", *time_str,st.wDay,st.wHour,st.wMinute,st.wSecond,st.wYear);
				break;
		case 6: sprintf(*time_str, "%sJun %d %.2d:%2.2d:%2.2d CEST %d", *time_str,st.wDay,st.wHour,st.wMinute,st.wSecond,st.wYear);
				break;
		case 7: sprintf(*time_str, "%sJul %d %.2d:%2.2d:%2.2d CEST %d", *time_str,st.wDay,st.wHour,st.wMinute,st.wSecond,st.wYear);
				break;
		case 8: sprintf(*time_str, "%sAug %d %.2d:%2.2d:%2.2d CEST %d", *time_str,st.wDay,st.wHour,st.wMinute,st.wSecond,st.wYear);
				break;
		case 9: sprintf(*time_str, "%sSep %d %.2d:%2.2d:%2.2d CEST %d", *time_str,st.wDay,st.wHour,st.wMinute,st.wSecond,st.wYear);
				break;
		case 10: sprintf(*time_str, "%sOct %d %.2d:%2.2d:%2.2d CEST %d", *time_str,st.wDay,st.wHour,st.wMinute,st.wSecond,st.wYear);
				break;
		case 11: sprintf(*time_str, "%sNov %d %.2d:%2.2d:%2.2d CEST %d", *time_str,st.wDay,st.wHour,st.wMinute,st.wSecond,st.wYear);
				break;
		default: sprintf(*time_str, "%sDec %d %.2d:%2.2d:%2.2d CEST %d", *time_str,st.wDay,st.wHour,st.wMinute,st.wSecond,st.wYear);		
	}
	
	return 1;
}
