/*****************************************************************************
 *
 * Copyright (C) 2002 Polytechnic University of Valencia.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Authors: Carlos Calafate, <calafate@disca.upv.es>
 *
 *****************************************************************************/

#include "ipfwd.h"


int PICAisForwarding(int * true_false) {
	MIB_IPSTATS lstats;

	if (true_false == NULL) {
		P_ERROR("PICAisForwarding: true_false points to NULL", 30101);
		return 0;
	}

	if (GetIpStatistics(&lstats) != NO_ERROR) {
		P_ERROR("PICAisForwarding: Error getting forwarding state", 30102);
		return 0;	
	}

	if (lstats.dwForwarding == 1) *true_false = 1;	
	else if (lstats.dwForwarding == 2) *true_false = 0;
	else {
		P_ERROR("PICAisForwarding: Unknown forwarding state", 30103);
		return 0;
	}

	return 1;
}

int PICAsetForwarding(int on_off) {
	MIB_IPSTATS lstats;

	if (GetIpStatistics(&lstats) != NO_ERROR) {
		P_ERROR("PICAsetForwarding: Error getting forwarding state", 30201);
		return 0;
	}
	
	if (on_off == 1) lstats.dwForwarding = 1; //start forwarding
	else if (on_off == 0) lstats.dwForwarding = 2; //stop forwarding
	else { //unknown option
	    P_ERROR("PICAsetForwarding: Invalid user value for forwarding state", 30202);
		return 0;
	}

	if (SetIpStatistics(&lstats) != NO_ERROR) {
	    P_ERROR("PICAsetForwarding: Error setting forwarding state", 30203);	
		return 0;		
	}
	
	return 1;
}

int PICAdefaultTTL(int set_get, int * ttl) {
	MIB_IPSTATS lstats;

	
	if (ttl == NULL) {
		P_ERROR("PICAdefaultTTL: ttl points to NULL", 30301);
		return 0;
	}

  
	if (*ttl < 0 || *ttl > 255) {
		P_ERROR("PICAdefaultTTL: Invalid user value for system TTL", 30302);
		return 0;
	}
    
	if (set_get == TTL_SET) {
		if (SetIpTTL(*ttl) != NO_ERROR) {
			P_ERROR("PICAdefaultTTL: Error while setting system's TTL", 30303);
			return 0;
		}
	} else if (set_get == TTL_GET) {
		if (GetIpStatistics(&lstats) != NO_ERROR) {
			P_ERROR("PICAdefaultTTL: Error while getting system's TTL", 30304);	
			return 0;
		}
		*ttl = lstats.dwDefaultTTL;		
	} else {
		P_ERROR("PICAdefaultTTL: Invalid user action", 30305);
		return 0;
	}
  
  return 1;
}



