/*****************************************************************************
 *
 * Copyright (C) 2002 Polytechnic University of Valencia.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Authors: Carlos Calafate, <calafate@disca.upv.es>
 *
 *****************************************************************************/

#ifndef _DEVS_H
#define _DEVS_H

#include "PICAspec.h"

#include <Iphlpapi.h>
#include <stdio.h>
#include <string.h>

#define MAXDEVS 32
#define MAXDEVSIZE 128

typedef struct _DEVLIST {
  int num_devices;
  char dev_names[MAXDEVS][MAXDEVSIZE];
} DEVLIST;

typedef struct _DevAttrs {
  unsigned char ha[6];
  UINT32 ip_addr;
  UINT32 mask;
  long index;
} DevAttrs;

int PICAgetAvailableDevices(DEVLIST * devs);

int PICAgetDeviceAttrs(char * dev, DevAttrs * attrs);

#endif