/*****************************************************************************
 *
 * Copyright (C) 2002 Polytechnic University of Valencia.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Authors: Carlos Calafate, <calafate@disca.upv.es>
 *
 *****************************************************************************/


#include "PICAspec.h"
#include "MSInclude\packet32.h"


extern HANDLE timerMutex;
extern HANDLE timerEvent;
extern UINT64 base_time; //variable for PICAgetCurrTime()


HANDLE errormutex;

static char errbuf[PICA_ERR_BUF_SIZE] = "";
static int err_code = 0;


int PICAstartup(int flags) {
	SECURITY_ATTRIBUTES sa;
	WSADATA wsaData;
	SYSTEMTIME stref;
	FILETIME ftref;	

//creates SYSTEMTIME for now and January 1, 1970

	stref.wYear = 1970; 
    stref.wMonth = 1; 
    stref.wDay = 1; 
    stref.wHour = 0; 
    stref.wMinute = 0; 
    stref.wSecond = 0; 
    stref.wMilliseconds = 0; 	

//converts to file time	

	if (!SystemTimeToFileTime(&stref,&ftref)) {
		P_ERROR("PICAgetCurrTime: Error converting system time to file time", 80102);	
		return 0;
	}

//	Converts to 64 bits	

	base_time = ftref.dwHighDateTime;
	base_time <<= 32;
	base_time += ftref.dwLowDateTime;

	//initialize security descriptor

	sa.nLength = sizeof(SECURITY_ATTRIBUTES);
	sa.bInheritHandle = TRUE;
	sa.lpSecurityDescriptor = NULL;

	if ((timerMutex = CreateMutex(&sa,FALSE,NULL)) == NULL) {
		P_ERROR("PICAstartup: error creating mutex", 110101);
	    return 	0;
	}

	if ((errormutex = CreateMutex(&sa,FALSE,NULL)) == NULL) {
		P_ERROR("PICAstartup: error creating mutex", 110102);
	    return 	0;
	}
	if ((timerEvent = CreateEvent(&sa,FALSE,FALSE,L"TimerThrEv1")) == NULL) {
		P_ERROR("PICAstartup: error creating event", 110103);
	    return 	0;
	}

	if (WSAStartup( MAKEWORD( 1, 1 ), &wsaData ) != 0) {
		P_ERROR("PICAstartup: error starting WSAv1.1", 110104);	   
		return 0;
	}

	if (!PacketLoadDriver ()) {
		P_ERROR("PICAstartup: error in PacketLoadDriver", 110105);	   
		return 0;
	}

	return 1;
}

int PICAcleanup(void) {

	if (WSACleanup() != 0) {
		P_ERROR("PICAstartup: error cleaning up WSAv2.2", 110201);	   	
		return 0;	
	}
	if (!PacketUnloadDriver()) {
		P_ERROR("PICAstartup: error in PacketUnloadDriver()", 110202);	   	
		return 0;	
	}

	return 1;
}


int PICAgetLastError(char * err, int * code) {

  if (err == NULL) {
    P_ERROR("PICAgetLastError: error buffer points to NULL", 110201);
    return 0;
  } 

  if (code == NULL) {
    P_ERROR("PICAgetLastError: code points to NULL", 110202);
    return 0;
  }

  if (WaitForSingleObject(errormutex,INFINITE) != WAIT_OBJECT_0) {
	  P_ERROR("PICAgetLastError: Unable to lock mutex", 110203);	  
	  return 0;
  }
  strcpy(err, errbuf);
  *code = err_code;
  strcpy(errbuf,"");
  err_code = 0;
  if (!ReleaseMutex(errormutex)) {
	  P_ERROR("PICAgetLastError: Unable to unlock mutex", 110204);	  
	  return 0;
  }
  return 1;
}


void P_ERROR(char * message, int code) {
  WaitForSingleObject(errormutex,INFINITE);
  if (strlen(message) >98) strcpy(errbuf,"PICA's buffer size for error was too small");
  else strcpy(errbuf,message);
  err_code = code;
  ReleaseMutex(errormutex);
}

